/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.ui.endpoints.token;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.amber.oauth2.as.request.OAuthTokenRequest;
import org.apache.amber.oauth2.as.response.OAuthASResponse;
import org.apache.amber.oauth2.common.exception.OAuthProblemException;
import org.apache.amber.oauth2.common.exception.OAuthSystemException;
import org.apache.amber.oauth2.common.message.OAuthResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth.ui.OAuthClientException;
import org.wso2.carbon.identity.oauth.ui.endpoints.token.OAuth2TokenClient;
import org.wso2.carbon.identity.oauth.ui.endpoints.token.OAuthRequestWrapper;
import org.wso2.carbon.identity.oauth.ui.util.OAuthUIUtil;
import org.wso2.carbon.identity.oauth2.stub.dto.OAuth2AccessTokenRespDTO;

@Path(value="/")
public class OAuth2TokenEndpoint {
    private static Log log = LogFactory.getLog(OAuth2TokenEndpoint.class);

    @POST
    @Path(value="/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response issueAccessToken(@Context HttpServletRequest request, MultivaluedMap<String, String> paramMap) throws OAuthSystemException {
        OAuthRequestWrapper httpRequest = new OAuthRequestWrapper(request, paramMap);
        if (log.isDebugEnabled()) {
            this.logAccessTokenRequest((HttpServletRequest)httpRequest);
        }
        boolean basicAuthUsed = false;
        if (request.getHeader("Authorization") != null) {
            try {
                String[] clientCredentials = OAuthUIUtil.extractCredentialsFromAuthzHeader(request.getHeader("Authorization"));
                if (paramMap.containsKey((Object)"client_id") && paramMap.containsKey((Object)"client_secret")) {
                    return this.handleBasicAuthFailure();
                }
                paramMap.add((Object)"client_id", (Object)clientCredentials[0]);
                paramMap.add((Object)"client_secret", (Object)clientCredentials[1]);
                basicAuthUsed = true;
                log.debug((Object)"HTTP Authorization Header is available which will take precedence over the client credentials available as request parameters.");
            }
            catch (OAuthClientException e) {
                return this.handleBasicAuthFailure();
            }
        }
        try {
            OAuthTokenRequest oauthRequest = new OAuthTokenRequest((HttpServletRequest)httpRequest);
            OAuth2TokenClient tokenClient = new OAuth2TokenClient();
            OAuth2AccessTokenRespDTO oauth2AccessTokenResp = tokenClient.getAccessToken(oauthRequest);
            if (oauth2AccessTokenResp.getError()) {
                if (basicAuthUsed && "invalid_client".equals(oauth2AccessTokenResp.getErrorCode())) {
                    return this.handleBasicAuthFailure();
                }
                OAuthResponse response = OAuthASResponse.errorResponse((int)400).setError(oauth2AccessTokenResp.getErrorCode()).setErrorDescription(oauth2AccessTokenResp.getErrorMsg()).buildJSONMessage();
                return Response.status((int)response.getResponseStatus()).entity((Object)response.getBody()).build();
            }
            OAuthResponse response = OAuthASResponse.tokenResponse((int)200).setAccessToken(oauth2AccessTokenResp.getAccessToken()).setRefreshToken(oauth2AccessTokenResp.getRefreshToken()).setExpiresIn("3600").setTokenType("bearer").buildJSONMessage();
            return Response.status((int)response.getResponseStatus()).header("Cache-Control", (Object)"no-store").header("Pragma", (Object)"no-cache").entity((Object)response.getBody()).build();
        }
        catch (OAuthProblemException e) {
            log.debug((Object)e.getError());
            OAuthResponse res = OAuthASResponse.errorResponse((int)400).error(e).buildJSONMessage();
            return Response.status((int)res.getResponseStatus()).entity((Object)res.getBody()).build();
        }
        catch (OAuthClientException e) {
            OAuthResponse response = OAuthASResponse.errorResponse((int)500).setError("server_error").setErrorDescription(e.getMessage()).buildJSONMessage();
            return Response.status((int)response.getResponseStatus()).entity((Object)response.getBody()).build();
        }
    }

    private Response handleBasicAuthFailure() throws OAuthSystemException {
        OAuthResponse response = OAuthASResponse.errorResponse((int)401).setError("invalid_client").setErrorDescription("Client Authentication was failed.").buildJSONMessage();
        return Response.status((int)response.getResponseStatus()).header("WWW-Authenticate", (Object)OAuthUIUtil.getRealmInfo()).entity((Object)response.getBody()).build();
    }

    private void logAccessTokenRequest(HttpServletRequest request) {
        log.debug((Object)("Received a request : " + request.getRequestURI()));
        log.debug((Object)"----------logging request headers.----------");
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headers = request.getHeaders(headerName);
            while (headers.hasMoreElements()) {
                log.debug((Object)(headerName + " : " + headers.nextElement()));
            }
        }
        log.debug((Object)"----------logging request parameters.----------");
        log.debug((Object)("grant_type - " + request.getParameter("grant_type")));
        log.debug((Object)("client_id - " + request.getParameter("client_id")));
        log.debug((Object)("code - " + request.getParameter("code")));
        log.debug((Object)("redirect_uri - " + request.getParameter("redirect_uri")));
    }
}

