/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.ui.endpoints.authz;

import java.io.IOException;
import java.rmi.RemoteException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.amber.oauth2.as.request.OAuthAuthzRequest;
import org.apache.amber.oauth2.as.response.OAuthASResponse;
import org.apache.amber.oauth2.common.exception.OAuthProblemException;
import org.apache.amber.oauth2.common.exception.OAuthSystemException;
import org.apache.amber.oauth2.common.message.OAuthResponse;
import org.apache.amber.oauth2.common.message.types.ResponseType;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth.ui.OAuth2Parameters;
import org.wso2.carbon.identity.oauth.ui.client.OAuth2ServiceClient;
import org.wso2.carbon.identity.oauth2.stub.dto.OAuth2AuthorizeReqDTO;
import org.wso2.carbon.identity.oauth2.stub.dto.OAuth2AuthorizeRespDTO;
import org.wso2.carbon.identity.oauth2.stub.dto.OAuth2ClientValidationResponseDTO;
import org.wso2.carbon.ui.CarbonUIUtil;

public class OAuth2AuthzEndpoint
extends HttpServlet {
    private static final Log log = LogFactory.getLog(OAuth2AuthzEndpoint.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.service(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.service(req, resp);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            if ("true".equals(req.getParameter("denied"))) {
                String redirectURL = this.handleAuthzDenial(req);
                resp.sendRedirect(redirectURL);
                return;
            }
            if (req.getParameter("oauth_user_name") != null && req.getParameter("oauth_user_password") != null) {
                String redirectURL = this.handleResourceOwnerAuthorization(req, resp);
                resp.sendRedirect(redirectURL);
                return;
            }
            if (req.getRequestURI().endsWith("authorize")) {
                String redirectURL = this.handleOAuthAuthorizationRequest(req);
                resp.sendRedirect(redirectURL);
            } else {
                HttpSession session = req.getSession();
                session.setAttribute("oauthErrorCode", (Object)"invalid_request_url");
                session.setAttribute("oauthErrorMsg", (Object)"Invalid OAuth request URL.");
                String errorPageURL = CarbonUIUtil.getAdminConsoleURL((HttpServletRequest)req) + "oauth/oauth-error.jsp";
                errorPageURL = errorPageURL.replace("/oauth2/authorize", "");
                resp.sendRedirect(errorPageURL);
            }
        }
        catch (OAuthSystemException e) {
            log.error((Object)"Error when processing the authorization request.", (Throwable)e);
            HttpSession session = req.getSession();
            session.setAttribute("oauthErrorCode", (Object)"server_error");
            session.setAttribute("oauthErrorMsg", (Object)"Error when processing the authorization request.");
            String errorPageURL = CarbonUIUtil.getAdminConsoleURL((HttpServletRequest)req) + "oauth/oauth-error.jsp";
            errorPageURL = errorPageURL.replace("/oauth2/authorize", "");
            resp.sendRedirect(errorPageURL);
        }
    }

    private String handleOAuthAuthorizationRequest(HttpServletRequest req) throws IOException, OAuthSystemException {
        OAuth2ClientValidationResponseDTO clientValidationResponseDTO = null;
        try {
            String clientId = req.getParameter("client_id");
            String callbackURL = req.getParameter("redirect_uri");
            if (clientId == null) {
                log.warn((Object)"Client Id is not present in the authorization request.");
                HttpSession session = req.getSession();
                session.setAttribute("oauthErrorCode", (Object)"invalid_request");
                session.setAttribute("oauthErrorMsg", (Object)"Invalid Request. Client Id is not present in the request");
                String errorPageURL = CarbonUIUtil.getAdminConsoleURL((HttpServletRequest)req) + "oauth/oauth-error.jsp";
                errorPageURL = errorPageURL.replace("/oauth2/authorize", "");
                return errorPageURL;
            }
            clientValidationResponseDTO = this.validateClient(req, clientId, callbackURL);
            if (!clientValidationResponseDTO.getValidClient()) {
                HttpSession session = req.getSession();
                session.setAttribute("oauthErrorCode", (Object)clientValidationResponseDTO.getErrorCode());
                session.setAttribute("oauthErrorMsg", (Object)clientValidationResponseDTO.getErrorMsg());
                String errorPageURL = CarbonUIUtil.getAdminConsoleURL((HttpServletRequest)req) + "oauth/oauth-error.jsp";
                errorPageURL = errorPageURL.replace("/oauth2/authorize", "");
                return errorPageURL;
            }
            OAuthAuthzRequest oauthRequest = new OAuthAuthzRequest(req);
            OAuth2Parameters params = new OAuth2Parameters();
            params.setApplicationName(clientValidationResponseDTO.getApplicationName());
            params.setRedirectURI(clientValidationResponseDTO.getCallbackURL());
            params.setResponseType(oauthRequest.getResponseType());
            params.setScopes(oauthRequest.getScopes());
            params.setState(oauthRequest.getState());
            params.setClientId(clientId);
            HttpSession session = req.getSession();
            session.setAttribute("oauth2Parameters", (Object)params);
            String loginPage = CarbonUIUtil.getAdminConsoleURL((HttpServletRequest)req) + "oauth/oauth2-login.jsp";
            loginPage = loginPage.replace("/oauth2/authorize", "");
            return loginPage;
        }
        catch (OAuthProblemException e) {
            log.error((Object)e.getError(), e.getCause());
            return OAuthASResponse.errorResponse((int)302).error(e).location(clientValidationResponseDTO.getCallbackURL()).buildQueryMessage().getLocationUri();
        }
    }

    private String handleResourceOwnerAuthorization(HttpServletRequest req, HttpServletResponse resp) throws IOException, OAuthSystemException {
        OAuth2Parameters oauth2Params = (OAuth2Parameters)req.getSession().getAttribute("oauth2Parameters");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Request from the oauth2-login.jsp for the user : " + req.getParameter("oauth_user_name")));
        }
        try {
            OAuthResponse response;
            OAuth2AuthorizeRespDTO authzRespDTO = this.authorize(req, oauth2Params);
            OAuthASResponse.OAuthAuthorizationResponseBuilder builder = OAuthASResponse.authorizationResponse((HttpServletRequest)req, (int)302);
            if (authzRespDTO.getAuthorized()) {
                if (ResponseType.CODE.toString().equals(oauth2Params.getResponseType())) {
                    builder.setCode(authzRespDTO.getAuthorizationCode());
                } else if (ResponseType.TOKEN.toString().equals(oauth2Params.getResponseType())) {
                    builder.setAccessToken(authzRespDTO.getAccessToken());
                    builder.setExpiresIn(String.valueOf(3600));
                }
                builder.setParam("state", oauth2Params.getState());
                String redirectURL = authzRespDTO.getCallbackURI();
                response = builder.location(redirectURL).buildQueryMessage();
            } else {
                OAuthProblemException oauthException = OAuthProblemException.error((String)authzRespDTO.getErrorCode(), (String)authzRespDTO.getErrorMsg());
                response = OAuthASResponse.errorResponse((int)302).error(oauthException).location(authzRespDTO.getCallbackURI()).setState(oauth2Params.getState()).buildQueryMessage();
            }
            resp.setStatus(302);
            return response.getLocationUri();
        }
        catch (OAuthProblemException e) {
            log.error((Object)e.getError(), e.getCause());
            return OAuthASResponse.errorResponse((int)302).error(e).location(oauth2Params.getRedirectURI()).buildQueryMessage().getLocationUri();
        }
    }

    private OAuth2AuthorizeRespDTO authorize(HttpServletRequest req, OAuth2Parameters oauth2Params) throws OAuthProblemException {
        try {
            String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)req.getSession().getServletContext(), (HttpSession)req.getSession());
            ConfigurationContext configContext = (ConfigurationContext)req.getSession().getServletContext().getAttribute("ConfigurationContext");
            OAuth2ServiceClient oauth2ServiceClient = new OAuth2ServiceClient(backendServerURL, configContext);
            OAuth2AuthorizeReqDTO authzReqDTO = new OAuth2AuthorizeReqDTO();
            authzReqDTO.setCallbackUrl(oauth2Params.getRedirectURI());
            authzReqDTO.setConsumerKey(oauth2Params.getClientId());
            authzReqDTO.setResponseType(oauth2Params.getResponseType());
            authzReqDTO.setScopes(oauth2Params.getScopes().toArray(new String[oauth2Params.getScopes().size()]));
            authzReqDTO.setUsername(req.getParameter("oauth_user_name"));
            authzReqDTO.setPassword(req.getParameter("oauth_user_password"));
            return oauth2ServiceClient.authorize(authzReqDTO);
        }
        catch (RemoteException e) {
            log.error((Object)"Error when invoking the OAuth2Service to perform authorization.", (Throwable)e);
            throw OAuthProblemException.error((String)"server_error", (String)"Error when invoking the OAuth2Service to perform authorization.");
        }
    }

    private OAuth2ClientValidationResponseDTO validateClient(HttpServletRequest req, String clientId, String callbackURL) throws OAuthSystemException {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)req.getSession().getServletContext(), (HttpSession)req.getSession());
        ConfigurationContext configContext = (ConfigurationContext)req.getSession().getServletContext().getAttribute("ConfigurationContext");
        try {
            OAuth2ServiceClient oauth2ServiceClient = new OAuth2ServiceClient(backendServerURL, configContext);
            return oauth2ServiceClient.validateClient(clientId, callbackURL);
        }
        catch (RemoteException e) {
            log.error((Object)"Error when invoking the OAuth2Service for client validation.");
            throw new OAuthSystemException(e.getMessage(), (Throwable)e);
        }
    }

    private String handleAuthzDenial(HttpServletRequest req) throws OAuthSystemException {
        OAuth2Parameters oauth2Params = (OAuth2Parameters)req.getSession().getAttribute("oauth2Parameters");
        OAuthProblemException oauthException = OAuthProblemException.error((String)"access_denied", (String)"User has denied Authorization.");
        OAuthResponse response = OAuthASResponse.errorResponse((int)302).error(oauthException).location(oauth2Params.getRedirectURI()).buildQueryMessage();
        return response.getLocationUri();
    }
}

