/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.ui.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.http.helper.ContextPathServletAdaptor;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.identity.oauth.ui.OAuthServlet;
import org.wso2.carbon.identity.oauth.ui.endpoints.authz.OAuth2AuthzEndpoint;
import org.wso2.carbon.identity.oauth.ui.endpoints.token.OAuth2EndpointApp;
import org.wso2.carbon.identity.oauth.ui.endpoints.token.OAuth2TokenEndpointServlet;
import org.wso2.carbon.identity.oauth.ui.internal.OAuthUIServiceComponentHolder;
import org.wso2.carbon.utils.ConfigurationContextService;

public class OAuthUIServiceComponent {
    private static final Log log = LogFactory.getLog(OAuthUIServiceComponent.class);
    private static final String PATH = "/oauth2/token";
    private HttpService httpService;

    protected void activate(ComponentContext context) {
        log.debug((Object)"Activating Identity OAuth UI bundle.");
        OAuthServlet oauthServlet = new OAuthServlet();
        Hashtable<String, String> oauthServletParams = new Hashtable<String, String>(2);
        ((Dictionary)oauthServletParams).put("url-pattern", "/oauth");
        ((Dictionary)oauthServletParams).put("display-name", "OAuth 1.0a Endpoint Handler.");
        context.getBundleContext().registerService(Servlet.class.getName(), (Object)oauthServlet, oauthServletParams);
        log.debug((Object)"Successfully registered an instance of OAuthServlet");
        ContextPathServletAdaptor oauth2Servlet = new ContextPathServletAdaptor((Servlet)new OAuth2AuthzEndpoint(), "/oauth2/authorize");
        try {
            this.httpService.registerServlet("/oauth2/authorize", (Servlet)oauth2Servlet, null, null);
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
        catch (NamespaceException e) {
            e.printStackTrace();
        }
        log.debug((Object)"Successfully registered an instance of OAuth2 Authorization Endpoint");
        log.debug((Object)"Successfully activated Identity OAuth UI bundle.");
    }

    protected void deactivate(ComponentContext context) {
        log.debug((Object)"Identity OAuth UI bundle is deactivated");
    }

    protected void setHttpService(HttpService httpService) {
        this.httpService = httpService;
        Hashtable<String, String> oauth2TokEndpointParams = new Hashtable<String, String>();
        ((Dictionary)oauth2TokEndpointParams).put("javax.ws.rs.Application", OAuth2EndpointApp.class.getName());
        try {
            httpService.registerServlet(PATH, (Servlet)new OAuth2TokenEndpointServlet(), oauth2TokEndpointParams, null);
        }
        catch (Exception e) {
            log.error((Object)"Error when registering the OAuth2TokenEndpointServlet via the HttpService.", (Throwable)e);
            throw new RuntimeException("Error when registering the OAuth2TokenEndpointServlet via the HttpService.", e);
        }
        log.debug((Object)"Successfully registered an instance of OAuth2 Token Endpoint");
    }

    protected void unsetHttpService(HttpService httpService) {
        httpService.unregister(PATH);
    }

    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        OAuthUIServiceComponentHolder.getInstance().setConfigurationContextService(configurationContextService);
        log.debug((Object)"ConfigurationContextService Instance was set.");
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        OAuthUIServiceComponentHolder.getInstance().setConfigurationContextService(null);
        log.debug((Object)"ConfigurationContextService Instance was unset.");
    }

    protected void setServerConfigurationService(ServerConfigurationService serverConfigService) {
        OAuthUIServiceComponentHolder.getInstance().setServerConfigurationService(serverConfigService);
        log.debug((Object)"ServerConfigurationService instance was set.");
    }

    protected void unsetServerConfigurationService(ServerConfigurationService serverConfigService) {
        OAuthUIServiceComponentHolder.getInstance().setServerConfigurationService(null);
        log.debug((Object)"ServerConfigurationService instance was unset.");
    }
}

