/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.ui.endpoints.token;

import org.apache.amber.oauth2.as.request.OAuthTokenRequest;
import org.apache.amber.oauth2.common.message.types.GrantType;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.identity.oauth.ui.OAuthClientException;
import org.wso2.carbon.identity.oauth.ui.client.OAuth2ServiceClient;
import org.wso2.carbon.identity.oauth.ui.internal.OAuthUIServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.stub.dto.OAuth2AccessTokenReqDTO;
import org.wso2.carbon.identity.oauth2.stub.dto.OAuth2AccessTokenRespDTO;
import org.wso2.carbon.ui.CarbonUIUtil;

public class OAuth2TokenClient {
    private static Log log = LogFactory.getLog(OAuth2TokenClient.class);
    private String backendServerURL;
    private ConfigurationContext configContext;

    public OAuth2TokenClient() {
        OAuthUIServiceComponentHolder serviceComponentHolder = OAuthUIServiceComponentHolder.getInstance();
        this.backendServerURL = CarbonUIUtil.getServerURL((ServerConfigurationService)serviceComponentHolder.getServerConfigurationService());
        this.configContext = serviceComponentHolder.getConfigurationContextService().getClientConfigContext();
    }

    public OAuth2AccessTokenRespDTO getAccessToken(OAuthTokenRequest oauthRequest) throws OAuthClientException {
        OAuth2AccessTokenReqDTO tokenReqDTO = new OAuth2AccessTokenReqDTO();
        String grantType = oauthRequest.getGrantType();
        tokenReqDTO.setGrantType(grantType);
        tokenReqDTO.setClientId(oauthRequest.getClientId());
        tokenReqDTO.setClientSecret(oauthRequest.getClientSecret());
        tokenReqDTO.setScope(oauthRequest.getScopes().toArray(new String[oauthRequest.getScopes().size()]));
        if (GrantType.AUTHORIZATION_CODE.toString().equals(grantType)) {
            tokenReqDTO.setAuthorizationCode(oauthRequest.getCode());
        } else if (GrantType.PASSWORD.toString().equals(grantType)) {
            tokenReqDTO.setResourceOwnerUsername(oauthRequest.getUsername());
            tokenReqDTO.setResourceOwnerPassword(oauthRequest.getPassword());
        } else if (GrantType.REFRESH_TOKEN.toString().equals(grantType)) {
            tokenReqDTO.setRefreshToken(oauthRequest.getRefreshToken());
        }
        try {
            OAuth2ServiceClient oauth2ServiceClient = new OAuth2ServiceClient(this.backendServerURL, this.configContext);
            return oauth2ServiceClient.issueAccessToken(tokenReqDTO);
        }
        catch (Exception e) {
            String errorMsg = "Error when invoking the OAuth2Service to get an access token.";
            log.error((Object)errorMsg, (Throwable)e);
            throw new OAuthClientException(errorMsg, e);
        }
    }
}

