/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.ui.util;

import javax.servlet.http.HttpServletRequest;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.identity.oauth.ui.OAuthClientException;
import org.wso2.carbon.ui.CarbonUIUtil;

public class OAuthUIUtil {
    private static Log log = LogFactory.getLog(OAuthUIUtil.class);

    public static String getAbsoluteEndpointURL(String endpointType, String oauthVersion, HttpServletRequest request) {
        String adminConsoleURL = CarbonUIUtil.getAdminConsoleURL((HttpServletRequest)request);
        String endpointURL = adminConsoleURL.substring(0, adminConsoleURL.indexOf("/carbon"));
        String oauthServletContext = "/oauth2";
        if (oauthVersion.equals("OAuth-1.0a")) {
            oauthServletContext = "/oauth";
        }
        return endpointURL + oauthServletContext + endpointType;
    }

    public static String[] extractCredentialsFromAuthzHeader(String authorizationHeader) throws OAuthClientException {
        String[] splitValues = authorizationHeader.trim().split(" ");
        byte[] decodedBytes = Base64Utils.decode((String)splitValues[1].trim());
        if (decodedBytes != null) {
            String userNamePassword = new String(decodedBytes);
            return userNamePassword.split(":");
        }
        String errMsg = "Error decoding authorization header. Could not retrieve user name and password.";
        log.debug((Object)errMsg);
        throw new OAuthClientException(errMsg);
    }

    public static String getRealmInfo() {
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        String hostname = serverConfig.getFirstProperty("HostName");
        return "Basic realm=" + hostname;
    }
}

