/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.util;

import com.google.gdata.client.authn.oauth.OAuthException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.dao.OAuthConsumerDAO;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class OAuth2Util {
    private static Log log = LogFactory.getLog(OAuth2Util.class);

    public static String buildScopeString(String[] scopes) {
        StringBuffer scopeString = new StringBuffer("");
        if (scopes != null) {
            for (String scope : scopes) {
                scopeString.append(scope);
                scopeString.append(',');
            }
        }
        return scopeString.toString();
    }

    public static boolean authenticateUser(String username, String password) throws OAuthException {
        try {
            String tenantUser = MultitenantUtils.getTenantAwareUsername((String)username);
            String domainName = MultitenantUtils.getTenantDomain((String)username);
            return IdentityTenantUtil.getRealm((String)domainName, (String)username).getUserStoreManager().authenticate(tenantUser, (Object)password);
        }
        catch (Exception e) {
            log.error((Object)"Error when authenticating the user for OAuth Authorization.", (Throwable)e);
            throw new OAuthException("Error when authenticating the user for OAuth Authorization.", (Throwable)e);
        }
    }

    public static boolean authenticateClient(String clientId, String clientSecretProvided) throws IdentityOAuthAdminException {
        OAuthConsumerDAO oAuthConsumerDAO = new OAuthConsumerDAO();
        String clientSecret = oAuthConsumerDAO.getOAuthConsumerSecret(clientId);
        if (clientSecret == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Provided Client ID : " + clientId + "is not valid."));
            }
            return false;
        }
        if (!clientSecret.equals(clientSecretProvided)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Provided the Client ID : " + clientId + " and Client Secret do not match with the issued credentials."));
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Successfully authenticated the client with client id : " + clientId));
        }
        return true;
    }
}

