/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.persistence.JDBCPersistenceManager;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;

public class TokenMgtDAO {
    private static final Log log = LogFactory.getLog(TokenMgtDAO.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void storeAuthorizationCode(String authzCode, String consumerKey, String scopeString, String authorizedUser) throws IdentityOAuth2Exception {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        try {
            connection = JDBCPersistenceManager.getInstance().getDBConnection();
            prepStmt = connection.prepareStatement("INSERT INTO IDENTITY_OAUTH2_AUTHORIZATION_CODE (AUTHORIZATION_CODE, CONSUMER_KEY, SCOPE, AUTHZ_USER) VALUES (?,?,?,?)");
            prepStmt.setString(1, authzCode);
            prepStmt.setString(2, consumerKey);
            prepStmt.setString(3, scopeString);
            prepStmt.setString(4, authorizedUser);
            prepStmt.execute();
            connection.commit();
        }
        catch (IdentityException e) {
            try {
                String errorMsg = "Error when getting an Identity Persistence Store instance.";
                log.error((Object)errorMsg, (Throwable)e);
                throw new IdentityOAuth2Exception(errorMsg, e);
                catch (SQLException e2) {
                    log.error((Object)"Error when executing the SQL : INSERT INTO IDENTITY_OAUTH2_AUTHORIZATION_CODE (AUTHORIZATION_CODE, CONSUMER_KEY, SCOPE, AUTHZ_USER) VALUES (?,?,?,?)");
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new IdentityOAuth2Exception("Error when storing the access code for consumer key : " + consumerKey);
                }
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void storeAccessToken(String accessToken, String refreshToken, String consumerKey, String authzUser, Timestamp timeStamp, long validityPeriod, String scopeString, String tokenState) throws IdentityOAuth2Exception {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        try {
            connection = JDBCPersistenceManager.getInstance().getDBConnection();
            prepStmt = connection.prepareStatement("INSERT INTO IDENTITY_OAUTH2_ACCESS_TOKEN (ACCESS_TOKEN, REFRESH_TOKEN, CONSUMER_KEY, AUTHZ_USER, TIME_CREATED, VALIDITY_PERIOD, TOKEN_SCOPE, TOKEN_STATE) VALUES (?,?,?,?,?,?,?,?)");
            prepStmt.setString(1, accessToken);
            prepStmt.setString(2, refreshToken);
            prepStmt.setString(3, consumerKey);
            prepStmt.setString(4, authzUser);
            prepStmt.setTimestamp(5, timeStamp);
            prepStmt.setLong(6, validityPeriod);
            prepStmt.setString(7, scopeString);
            prepStmt.setString(8, tokenState);
            prepStmt.execute();
            connection.commit();
        }
        catch (IdentityException e) {
            try {
                String errorMsg = "Error when getting an Identity Persistence Store instance.";
                log.error((Object)errorMsg, (Throwable)e);
                throw new IdentityOAuth2Exception(errorMsg, e);
                catch (SQLException e2) {
                    log.error((Object)"Error when executing the SQL : INSERT INTO IDENTITY_OAUTH2_ACCESS_TOKEN (ACCESS_TOKEN, REFRESH_TOKEN, CONSUMER_KEY, AUTHZ_USER, TIME_CREATED, VALIDITY_PERIOD, TOKEN_SCOPE, TOKEN_STATE) VALUES (?,?,?,?,?,?,?,?)");
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new IdentityOAuth2Exception("Error when storing the access code for consumer key : " + consumerKey);
                }
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] validateAuthorizationCode(String consumerKey, String authorizationKey) throws IdentityOAuth2Exception {
        String authorizedUser = null;
        String scope = null;
        Connection connection = null;
        PreparedStatement prepStmt = null;
        try {
            connection = JDBCPersistenceManager.getInstance().getDBConnection();
            prepStmt = connection.prepareStatement("SELECT AUTHZ_USER, SCOPE FROM IDENTITY_OAUTH2_AUTHORIZATION_CODE where CONSUMER_KEY = ? AND AUTHORIZATION_CODE = ?");
            prepStmt.setString(1, consumerKey);
            prepStmt.setString(2, authorizationKey);
            ResultSet resultSet = prepStmt.executeQuery();
            if (resultSet.next()) {
                authorizedUser = resultSet.getString(1);
                scope = resultSet.getString(2);
            }
        }
        catch (IdentityException e) {
            try {
                String errorMsg = "Error when getting an Identity Persistence Store instance.";
                log.error((Object)errorMsg, (Throwable)e);
                throw new IdentityOAuth2Exception(errorMsg, e);
                catch (SQLException e2) {
                    log.error((Object)"Error when executing the SQL : SELECT AUTHZ_USER, SCOPE FROM IDENTITY_OAUTH2_AUTHORIZATION_CODE where CONSUMER_KEY = ? AND AUTHORIZATION_CODE = ?");
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new IdentityOAuth2Exception("Error when validating the authorization code", e2);
                }
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
        return new String[]{authorizedUser, scope};
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cleanUpAuthzCode(String authzCode) throws IdentityOAuth2Exception {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        try {
            connection = JDBCPersistenceManager.getInstance().getDBConnection();
            prepStmt = connection.prepareStatement("DELETE FROM IDENTITY_OAUTH2_AUTHORIZATION_CODE WHERE AUTHORIZATION_CODE = ?");
            prepStmt.setString(1, authzCode);
            prepStmt.execute();
            connection.commit();
        }
        catch (IdentityException e) {
            try {
                String errorMsg = "Error when getting an Identity Persistence Store instance.";
                log.error((Object)errorMsg, (Throwable)e);
                throw new IdentityOAuth2Exception(errorMsg, e);
                catch (SQLException e2) {
                    log.error((Object)"Error when executing the SQL : DELETE FROM IDENTITY_OAUTH2_AUTHORIZATION_CODE WHERE AUTHORIZATION_CODE = ?");
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new IdentityOAuth2Exception("Error when cleaning up the authorization code", e2);
                }
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
    }
}

