/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2;

import com.google.gdata.client.authn.oauth.OAuthException;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.amber.oauth2.as.issuer.MD5Generator;
import org.apache.amber.oauth2.as.issuer.OAuthIssuerImpl;
import org.apache.amber.oauth2.as.issuer.ValueGenerator;
import org.apache.amber.oauth2.common.message.types.GrantType;
import org.apache.amber.oauth2.common.message.types.ResponseType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.identity.core.model.OAuthAppDO;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.authz.OAuthAuthorizationCallback;
import org.wso2.carbon.identity.oauth.authz.OAuthAuthorizationHandler;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDAO;
import org.wso2.carbon.identity.oauth2.AccessTokenIssuer;
import org.wso2.carbon.identity.oauth2.AuthorizationCodeValidator;
import org.wso2.carbon.identity.oauth2.AuthorizationGrantHandler;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.PasswordGrantHandler;
import org.wso2.carbon.identity.oauth2.dao.TokenMgtDAO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenReqDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenRespDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeReqDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeRespDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2ClientValidationResponseDTO;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class OAuth2Service
extends AbstractAdmin {
    private static Log log = LogFactory.getLog(OAuth2Service.class);

    public OAuth2AuthorizeRespDTO authorize(OAuth2AuthorizeReqDTO authorizeDTO) {
        boolean isAuthenticated;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authorization Request received for user : " + authorizeDTO.getUsername() + ", Client ID : " + authorizeDTO.getConsumerKey() + ", Authorization Response Type : " + authorizeDTO.getResponseType() + ", Requested callback URI : " + authorizeDTO.getCallbackUrl() + ", Requested Scope : " + OAuth2Util.buildScopeString(authorizeDTO.getScopes())));
        }
        OAuth2AuthorizeRespDTO respDTO = new OAuth2AuthorizeRespDTO();
        try {
            isAuthenticated = OAuth2Util.authenticateUser(authorizeDTO.getUsername(), authorizeDTO.getPassword());
        }
        catch (OAuthException e) {
            log.error((Object)"Error occurred when authenticating the user.");
            this.handleErrorRequest(respDTO, "server_error", "Error occurred when authenticating the user.");
            return respDTO;
        }
        if (!isAuthenticated) {
            log.info((Object)("User Authentication failed for user : " + authorizeDTO.getUsername()));
            this.handleErrorRequest(respDTO, "access_denied", "Authentication Failure, Invalid Credentials!");
            return respDTO;
        }
        OAuthAuthorizationCallback authzCallback = new OAuthAuthorizationCallback(authorizeDTO.getUsername(), authorizeDTO.getConsumerKey(), authorizeDTO.getScopes());
        try {
            OAuthAuthorizationHandler authzHandler = new OAuthAuthorizationHandler();
            authzHandler.handleAuthorization(authzCallback);
        }
        catch (IdentityOAuth2Exception e) {
            this.handleErrorRequest(respDTO, "server_error", "Error occurred when authorizing the user.");
            return respDTO;
        }
        if (!authzCallback.isAuthorized() || authzCallback.isInvalidScope()) {
            if (authzCallback.isInvalidScope()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invalid scope. : Username : " + authorizeDTO.getUsername() + " Scope : " + OAuth2Util.buildScopeString(authorizeDTO.getScopes())));
                }
                this.handleErrorRequest(respDTO, "invalid_scope", "Invalid Scope.");
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User does not have right permissions to grant access to the resource : Username : " + authorizeDTO.getUsername() + " Scope : " + OAuth2Util.buildScopeString(authorizeDTO.getScopes())));
                }
                this.handleErrorRequest(respDTO, "unauthorized_client", "Resource Owner does not have enough permissions to grant access.");
            }
            return respDTO;
        }
        OAuthIssuerImpl oauthIssuerImpl = new OAuthIssuerImpl((ValueGenerator)new MD5Generator());
        TokenMgtDAO tokenMgtDAO = new TokenMgtDAO();
        String scopeString = OAuth2Util.buildScopeString(authzCallback.getScope());
        try {
            if (ResponseType.CODE.toString().equals(authorizeDTO.getResponseType())) {
                String authorizationCode = oauthIssuerImpl.authorizationCode();
                tokenMgtDAO.storeAuthorizationCode(authorizationCode, authorizeDTO.getConsumerKey(), scopeString, authorizeDTO.getUsername());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Issued Authorization Code to user : " + authorizeDTO.getUsername() + ". Using the redirect url : " + authorizeDTO.getCallbackUrl()));
                }
                respDTO.setAuthorized(true);
                respDTO.setAuthorizationCode(authorizationCode);
                respDTO.setCallbackURI(authorizeDTO.getCallbackUrl());
                return respDTO;
            }
            if (ResponseType.TOKEN.toString().equals(authorizeDTO.getResponseType())) {
                String accessToken = oauthIssuerImpl.accessToken();
                Timestamp timestamp = new Timestamp(new Date().getTime());
                long validityPeriod = 3600L;
                tokenMgtDAO.storeAccessToken(accessToken, null, authorizeDTO.getConsumerKey(), authorizeDTO.getUsername(), timestamp, validityPeriod, scopeString, "Active");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Issued AccessToken Code to user : " + authorizeDTO.getUsername() + ". Using the redirect url : " + authorizeDTO.getCallbackUrl()));
                }
                respDTO.setAuthorized(true);
                respDTO.setAccessToken(accessToken);
                respDTO.setValidityPeriod(validityPeriod);
                respDTO.setCallbackURI(authorizeDTO.getCallbackUrl());
                return respDTO;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unsupported Response Type." + authorizeDTO.getResponseType()));
            }
            this.handleErrorRequest(respDTO, "unsupported_response_type", "Unsupported Response Type.");
            return respDTO;
        }
        catch (Exception e) {
            log.error((Object)"Error occurred when processing the authorization request. Returning an error back to client.", (Throwable)e);
            this.handleErrorRequest(respDTO, "server_error", "Error occurred when processing the authorization request. Returning an error back to client.");
            return respDTO;
        }
    }

    public OAuth2ClientValidationResponseDTO validateClientInfo(String clientId, String callbackURI) {
        OAuth2ClientValidationResponseDTO validationResponseDTO = new OAuth2ClientValidationResponseDTO();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Validate Client information request for client_id : " + clientId + " and callback_uri " + callbackURI));
        }
        try {
            OAuthAppDAO oAuthAppDAO = new OAuthAppDAO();
            OAuthAppDO appDO = oAuthAppDAO.getAppInformation(clientId);
            if (appDO == null) {
                log.warn((Object)("No registered Client Id found against the given Client id : " + clientId));
                validationResponseDTO.setValidClient(false);
                validationResponseDTO.setErrorCode("unauthorized_client");
                validationResponseDTO.setErrorMsg("Invalid Client Id.");
                return validationResponseDTO;
            }
            if (callbackURI == null) {
                validationResponseDTO.setValidClient(true);
                validationResponseDTO.setCallbackURL(appDO.getCallbackUrl());
                validationResponseDTO.setApplicationName(appDO.getApplicationName());
                return validationResponseDTO;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Registered App found for the given Client Id : " + clientId + " ,App Name : " + appDO.getApplicationName() + ", Callback URL : " + appDO.getCallbackUrl()));
            }
            if (appDO.getCallbackUrl().equals(callbackURI)) {
                validationResponseDTO.setValidClient(true);
                validationResponseDTO.setApplicationName(appDO.getApplicationName());
                validationResponseDTO.setCallbackURL(callbackURI);
                return validationResponseDTO;
            }
            log.warn((Object)"Provided Callback URL does not match with the provided one.");
            validationResponseDTO.setValidClient(false);
            validationResponseDTO.setErrorCode("invalid_callback");
            validationResponseDTO.setErrorMsg("Registered callback does not match with the provided url.");
            return validationResponseDTO;
        }
        catch (IdentityOAuthAdminException e) {
            log.error((Object)"Error when reading the Application Information.", (Throwable)((Object)e));
            validationResponseDTO.setValidClient(false);
            validationResponseDTO.setErrorCode("server_error");
            validationResponseDTO.setErrorMsg("Error when processing the authorization request.");
            return validationResponseDTO;
        }
    }

    public OAuth2AccessTokenRespDTO issueAccessToken(OAuth2AccessTokenReqDTO tokenReqDTO) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Access Token Request Received with the Client Id : " + tokenReqDTO.getClientId() + ", Grant Type : " + tokenReqDTO.getGrantType()));
        }
        OAuth2AccessTokenRespDTO tokenRespDTO = new OAuth2AccessTokenRespDTO();
        try {
            boolean authenticateClient = OAuth2Util.authenticateClient(tokenReqDTO.getClientId(), tokenReqDTO.getClientSecret());
            if (!authenticateClient) {
                tokenRespDTO.setError(true);
                tokenRespDTO.setErrorCode("invalid_client");
                tokenRespDTO.setErrorMsg("Client Authentication Failed. Provided client id or client secret is incorrect.");
                return tokenRespDTO;
            }
            AccessTokenIssuer tokenIssuer = new AccessTokenIssuer(this.getAuthzGrantHandler(tokenReqDTO));
            return tokenIssuer.issue(tokenReqDTO);
        }
        catch (Exception e) {
            log.error((Object)"Error when issuing the access token. ", (Throwable)e);
            tokenRespDTO.setError(true);
            tokenRespDTO.setErrorCode("server_error");
            tokenRespDTO.setErrorMsg("Error when issuing the access token");
            return tokenRespDTO;
        }
    }

    private AuthorizationGrantHandler getAuthzGrantHandler(OAuth2AccessTokenReqDTO reqDTO) {
        if (GrantType.AUTHORIZATION_CODE.toString().equals(reqDTO.getGrantType())) {
            return new AuthorizationCodeValidator(reqDTO);
        }
        if (GrantType.PASSWORD.toString().equals(reqDTO.getGrantType())) {
            return new PasswordGrantHandler(reqDTO);
        }
        return null;
    }

    private void handleErrorRequest(OAuth2AuthorizeRespDTO respDTO, String errorCode, String errorMsg) {
        respDTO.setAuthorized(false);
        respDTO.setErrorCode(errorCode);
        respDTO.setErrorMsg(errorMsg);
    }
}

