/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.oauth2.AbstractAuthorizationGrantHandler;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenReqDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenRespDTO;

public class AuthorizationCodeValidator
extends AbstractAuthorizationGrantHandler {
    private static Log log = LogFactory.getLog(AuthorizationCodeValidator.class);

    public AuthorizationCodeValidator(OAuth2AccessTokenReqDTO reqDTO) {
        super(reqDTO);
    }

    @Override
    public boolean validate() throws IdentityException {
        String authorizationCode = this.oAuth2AccessTokenReqDTO.getAuthorizationCode();
        String[] authzData = this.tokenMgtDAO.validateAuthorizationCode(this.oAuth2AccessTokenReqDTO.getClientId(), authorizationCode);
        if (authzData[0] == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid access token request with Client Id : " + this.oAuth2AccessTokenReqDTO.getClientId() + " , Authorization Code : " + this.oAuth2AccessTokenReqDTO.getAuthorizationCode()));
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found an Authorization Code, Client : " + this.oAuth2AccessTokenReqDTO.getClientId() + " , Authorization Code : " + this.oAuth2AccessTokenReqDTO.getAuthorizationCode() + ", authorized user : " + authzData[0] + ", scope : " + authzData[1]));
        }
        this.authorizedUser = authzData[0];
        this.scope = authzData[1];
        return true;
    }

    @Override
    public OAuth2AccessTokenRespDTO issue() throws IdentityException {
        OAuth2AccessTokenRespDTO tokenRespDTO = super.issue();
        this.tokenMgtDAO.cleanUpAuthzCode(this.oAuth2AccessTokenReqDTO.getAuthorizationCode());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authorization Code clean up completed for : " + this.oAuth2AccessTokenReqDTO.getAuthorizationCode()));
        }
        return tokenRespDTO;
    }
}

