/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.model.OAuthAppDO;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDAO;
import org.wso2.carbon.identity.oauth2.AuthorizationGrantHandler;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenReqDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenRespDTO;

public class AccessTokenIssuer {
    private AuthorizationGrantHandler authGrantHandler;
    private static Log log = LogFactory.getLog(AccessTokenIssuer.class);

    public AccessTokenIssuer(AuthorizationGrantHandler authGrantHandler) {
        this.authGrantHandler = authGrantHandler;
    }

    public OAuth2AccessTokenRespDTO issue(OAuth2AccessTokenReqDTO tokReqDTO) throws IdentityException {
        boolean isValid = this.authGrantHandler.validate();
        OAuthAppDO oAuthAppDO = new OAuthAppDAO().getAppInformation(tokReqDTO.getClientId());
        if (!isValid) {
            OAuth2AccessTokenRespDTO tokenRespDTO = new OAuth2AccessTokenRespDTO();
            tokenRespDTO.setError(true);
            tokenRespDTO.setErrorCode("invalid_grant");
            tokenRespDTO.setErrorMsg("Provided Authorization Grant is invalid.");
            return tokenRespDTO;
        }
        OAuth2AccessTokenRespDTO tokenRespDTO = this.authGrantHandler.issue();
        tokenRespDTO.setCallbackURI(oAuthAppDO.getCallbackUrl());
        return tokenRespDTO;
    }
}

