/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.authz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.callback.Callback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth.authz.OAuthAuthorizationCallback;
import org.wso2.carbon.identity.oauth.authz.OAuthAuthorizationCallbackHandler;
import org.wso2.carbon.identity.oauth.authz.OAuthAuthorizationCallbackHandlerMetaData;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class OAuthCallbackHandlerRegistry {
    private static Log log = LogFactory.getLog(OAuthCallbackHandlerRegistry.class);
    private static OAuthCallbackHandlerRegistry instance = new OAuthCallbackHandlerRegistry();
    private transient boolean initAuthzHandlers = false;
    private Set<OAuthAuthorizationCallbackHandlerMetaData> callbackHandlerMetaData = new HashSet<OAuthAuthorizationCallbackHandlerMetaData>();
    private OAuthAuthorizationCallbackHandler[] authzCallbackHandlers;

    private OAuthCallbackHandlerRegistry() {
    }

    public static OAuthCallbackHandlerRegistry getInstance() {
        return instance;
    }

    public void addOAuthAuthorizationCallbackHandlerMetadata(OAuthAuthorizationCallbackHandlerMetaData metaData) {
        this.callbackHandlerMetaData.add(metaData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initAuthzCallbackHandlers() throws IdentityOAuth2Exception {
        if (!this.initAuthzHandlers) {
            OAuthCallbackHandlerRegistry oAuthCallbackHandlerRegistry = this;
            synchronized (oAuthCallbackHandlerRegistry) {
                if (!this.initAuthzHandlers) {
                    log.debug((Object)"initializing the OAuth Authorization Callback Handlers.");
                    ArrayList<OAuthAuthorizationCallbackHandler> oauthAuthzHandlers = new ArrayList<OAuthAuthorizationCallbackHandler>();
                    for (OAuthAuthorizationCallbackHandlerMetaData metaData : this.callbackHandlerMetaData) {
                        String className = metaData.getClassName();
                        try {
                            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(metaData.getClassName());
                            OAuthAuthorizationCallbackHandler callbackHandler = (OAuthAuthorizationCallbackHandler)clazz.newInstance();
                            callbackHandler.setPriority(metaData.getPriority());
                            callbackHandler.setProperties(metaData.getProperties());
                            oauthAuthzHandlers.add(callbackHandler);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Instantiated an OAuth Authorization Callback Handler. Class : " + clazz.getName()));
                        }
                        catch (ClassNotFoundException e) {
                            String errorMsg = "Error when loading the OAuthAuthorizationCallbackHandler : " + className;
                            log.error((Object)errorMsg, (Throwable)e);
                            throw new IdentityOAuth2Exception(errorMsg, e);
                        }
                        catch (InstantiationException e) {
                            String errorMsg = "Error when instantiating the OAuthAuthorizationCallbackHandler : " + className;
                            log.error((Object)errorMsg, (Throwable)e);
                            throw new IdentityOAuth2Exception(errorMsg, e);
                        }
                        catch (IllegalAccessException e) {
                            String errorMsg = "Error when instantiating the OAuthAuthorizationCallbackHandler : " + className;
                            log.error((Object)errorMsg, (Throwable)e);
                            throw new IdentityOAuth2Exception(errorMsg, e);
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Finished initializing OAuth Authorization Callback Handlers. No. of Authz Handlers registered : " + oauthAuthzHandlers.size()));
                    }
                    this.authzCallbackHandlers = oauthAuthzHandlers.toArray(new OAuthAuthorizationCallbackHandler[oauthAuthzHandlers.size()]);
                    Arrays.sort(this.authzCallbackHandlers, new OAuthAuthzCbHandlerComparator());
                    this.initAuthzHandlers = true;
                }
            }
        }
    }

    public OAuthAuthorizationCallbackHandler getOAuthAuthzHandler(OAuthAuthorizationCallback authzCallback) throws IdentityOAuth2Exception {
        for (OAuthAuthorizationCallbackHandler oauthAuthzCbHandler : this.authzCallbackHandlers) {
            if (!oauthAuthzCbHandler.canHandle(new Callback[]{authzCallback})) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("OAuthAuthorizationCallbackHandler was found for the callback. Class Name : " + oauthAuthzCbHandler.getClass().getName() + " Resource Owner : " + authzCallback.getResourceOwner() + " Client Id : " + authzCallback.getClient() + " Scope : " + OAuth2Util.buildScopeString(authzCallback.getScope())));
            }
            return oauthAuthzCbHandler;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("No OAuthAuthorizationCallbackHandlers were found for the callback. Resource Owner : " + authzCallback.getResourceOwner() + " Client Id : " + authzCallback.getClient() + " Scope : " + OAuth2Util.buildScopeString(authzCallback.getScope())));
        }
        return null;
    }

    private class OAuthAuthzCbHandlerComparator
    implements Comparator<OAuthAuthorizationCallbackHandler> {
        private OAuthAuthzCbHandlerComparator() {
        }

        @Override
        public int compare(OAuthAuthorizationCallbackHandler o1, OAuthAuthorizationCallbackHandler o2) {
            return o1.getPriority() - o2.getPriority();
        }
    }
}

