/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.mediator;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth.stub.OAuthServiceStub;
import org.wso2.carbon.identity.oauth.stub.dto.OAuthConsumerDTO;
import org.wso2.carbon.identity.oauth.stub.types.Parameters;

public class OAuthServiceClient {
    private OAuthServiceStub stub = null;
    private static final Log log = LogFactory.getLog(OAuthServiceClient.class);

    public OAuthServiceClient(String backendServerURL, ConfigurationContext configCtx) throws Exception {
        String serviceURL = backendServerURL + "OAuthService";
        try {
            this.stub = new OAuthServiceStub(configCtx, serviceURL);
        }
        catch (AxisFault e) {
            log.error((Object)"Error initializing OAuth Client");
            throw new Exception("Error initializing OAuth Client", e);
        }
    }

    public boolean isOAuthConsumerValid(OAuthConsumerDTO oauthConsumer) throws Exception {
        try {
            return this.stub.isOAuthConsumerValid(oauthConsumer);
        }
        catch (RemoteException e) {
            log.error((Object)"Error while validating OAuth consumer credentials with 2-legged OAuth");
            throw new Exception("Error while validating OAuth consumer credentials with 2-legged OAuth", e);
        }
    }

    public boolean validateAuthenticationRequest(Parameters params) throws Exception {
        try {
            return this.stub.validateAuthenticationRequest(params);
        }
        catch (RemoteException e) {
            log.error((Object)"Error while validating OAuth consumer credentials with 3-legged OAuth");
            throw new Exception("Error while validating OAuth consumer credentials with 3-legged OAuth", e);
        }
    }
}

