/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.mediator;

import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.wso2.carbon.identity.oauth.mediator.OAuthServiceClient;
import org.wso2.carbon.identity.oauth.stub.dto.OAuthConsumerDTO;
import org.wso2.carbon.identity.oauth.stub.types.Parameters;

public class OAuthMediator
extends AbstractMediator {
    private static final Log log = LogFactory.getLog(OAuthMediator.class);
    private boolean remote = true;
    private String remoteServiceUrl;
    ConfigurationContext cfgCtx = null;
    private String clientRepository = null;
    private String axis2xml = null;
    public static final String DEFAULT_CLIENT_REPO = "./samples/axis2Client/client_repo";
    public static final String DEFAULT_AXIS2_XML = "./samples/axis2Client/client_repo/conf/axis2.xml";

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public String getRemoteServiceUrl() {
        if (this.remoteServiceUrl != null && !this.remoteServiceUrl.endsWith("/")) {
            this.remoteServiceUrl = this.remoteServiceUrl + "/";
        }
        return this.remoteServiceUrl;
    }

    public void setRemoteServiceUrl(String remoteServiceUrl) {
        this.remoteServiceUrl = remoteServiceUrl;
    }

    public void init(SynapseEnvironment synEnv) {
        try {
            this.cfgCtx = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)(this.clientRepository != null ? this.clientRepository : DEFAULT_CLIENT_REPO), (String)(this.axis2xml != null ? this.axis2xml : DEFAULT_AXIS2_XML));
        }
        catch (AxisFault e) {
            String msg = "Error initializing callout mediator : " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new SynapseException(msg, (Throwable)e);
        }
    }

    public boolean mediate(org.apache.synapse.MessageContext synCtx) {
        OAuthServiceClient client = null;
        ConfigurationContext configContext = null;
        OAuthConsumerDTO consumer = null;
        boolean isValidConsumer = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Mediation for OAuth started");
        }
        try {
            Parameters params = this.populateOauthConsumerData(synCtx);
            client = new OAuthServiceClient(this.getRemoteServiceUrl(), configContext);
            if (params != null && params.getOauthToken() == null) {
                consumer = new OAuthConsumerDTO();
                consumer.setBaseString(params.getBaseString());
                consumer.setHttpMethod(params.getHttpMethod());
                consumer.setOauthConsumerKey(params.getOauthConsumerKey());
                consumer.setOauthNonce(params.getOauthNonce());
                consumer.setOauthSignature(params.getOauthSignature());
                consumer.setOauthSignatureMethod(params.getOauthSignatureMethod());
                consumer.setOauthTimeStamp(params.getOauthTimeStamp());
                isValidConsumer = client.isOAuthConsumerValid(consumer);
            } else {
                isValidConsumer = client.validateAuthenticationRequest(params);
            }
            if (!isValidConsumer) {
                throw new SynapseException("OAuth authentication failed");
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Error occured while validating oauth consumer", (Throwable)e);
            throw new SynapseException("Error occured while validating oauth consumer");
        }
    }

    private Parameters populateOauthConsumerData(org.apache.synapse.MessageContext synCtx) {
        String authHeader = null;
        Parameters params = null;
        Map headersMap = null;
        String splitChar = ",";
        boolean noAuthorizationHeader = false;
        Axis2MessageContext axis2Msgcontext = null;
        axis2Msgcontext = (Axis2MessageContext)synCtx;
        MessageContext msgContext = axis2Msgcontext.getAxis2MessageContext();
        headersMap = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
        authHeader = (String)headersMap.get("Authorization");
        params = new Parameters();
        String operation = null;
        String queryString = (String)msgContext.getProperty("REST_URL_POSTFIX");
        if (queryString.indexOf("?") > -1) {
            String temp = queryString;
            queryString = queryString.substring(queryString.indexOf("?") + 1);
            operation = temp.substring(0, temp.indexOf("?") + 1);
        }
        if (authHeader == null) {
            noAuthorizationHeader = true;
            authHeader = queryString;
            splitChar = "&";
        }
        StringBuffer nonAuthParams = new StringBuffer();
        if (authHeader != null) {
            String[] headers;
            if (authHeader.startsWith("OAuth ")) {
                authHeader = authHeader.substring(authHeader.indexOf("o"));
            }
            if ((headers = authHeader.split(splitChar)) != null && headers.length > 0) {
                for (int i = 0; i < headers.length; ++i) {
                    String[] elements = headers[i].split("=");
                    if (elements == null || elements.length <= 0) continue;
                    if ("oauth_consumer_key".equals(elements[0].trim())) {
                        params.setOauthConsumerKey(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_nonce".equals(elements[0].trim())) {
                        params.setOauthNonce(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_signature".equals(elements[0].trim())) {
                        params.setOauthSignature(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_signature_method".equals(elements[0].trim())) {
                        params.setOauthSignatureMethod(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_timestamp".equals(elements[0].trim())) {
                        params.setOauthTimeStamp(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_callback".equals(elements[0].trim())) {
                        params.setOauthCallback(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("scope".equals(elements[0].trim())) {
                        params.setScope(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("xoauth_displayname".equals(elements[0].trim())) {
                        params.setDisplayName(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_token".equals(elements[0].trim())) {
                        params.setOauthToken(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_verifier".equals(elements[0].trim())) {
                        params.setOauthTokenVerifier(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_token_secret".equals(elements[0].trim())) {
                        params.setOauthTokenSecret(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_version".equals(elements[0].trim())) {
                        params.setVersion(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    nonAuthParams.append(elements[0].trim() + "=" + this.removeLeadingAndTrailingQuatation(elements[1].trim()) + "&");
                }
            }
        }
        String nonOauthParamStr = nonAuthParams.toString();
        if (!noAuthorizationHeader) {
            nonOauthParamStr = queryString + "&";
        }
        String scope = null;
        if (nonOauthParamStr.indexOf("scope=") > -1) {
            String postScope = nonOauthParamStr.substring(nonOauthParamStr.indexOf("scope="), nonOauthParamStr.length());
            scope = postScope.indexOf("&") > -1 ? postScope.substring(6, postScope.indexOf("&")) : postScope.substring(6, postScope.length());
        }
        if (scope != null) {
            params.setScope(scope);
        }
        params.setHttpMethod((String)msgContext.getProperty("HTTP_METHOD"));
        String prefix = (String)msgContext.getProperty("SERVICE_PREFIX");
        if (nonOauthParamStr.length() > 1) {
            params.setBaseString(prefix + operation + nonOauthParamStr.substring(0, nonOauthParamStr.length() - 1));
        } else {
            params.setBaseString(prefix);
        }
        return params;
    }

    private String removeLeadingAndTrailingQuatation(String base) {
        String result = base;
        if (base.startsWith("\"") || base.endsWith("\"")) {
            result = base.replace("\"", "");
        }
        return result.trim();
    }
}

