/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.entitlement.dto.PolicyDTO;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.policy.PolicyMetaDataBuilder;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.AuthorizationManager;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;

public class PolicyStore {
    private Registry registry;
    private static Log log = LogFactory.getLog(PolicyStore.class);

    public PolicyStore(Registry registry) throws IdentityException {
        if (registry == null) {
            log.error((Object)"Registry reference not set");
            throw new IdentityException("Registry reference not set");
        }
        this.registry = registry;
    }

    public Resource[] getActivePolicies() throws IdentityException {
        String path = null;
        Collection collection = null;
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        String[] children = null;
        int[] policyOrdering = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Retrieving active entitlement policies");
        }
        try {
            path = "/repository/identity/Entitlement/Policies/";
            if (!this.registry.resourceExists(path)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Trying to access an entitlement policy which does not exist");
                }
                return null;
            }
            collection = (Collection)this.registry.get(path);
            children = collection.getChildren();
            policyOrdering = new int[children.length];
            for (int i = 0; i < children.length; ++i) {
                Resource resource = this.registry.get(children[i]);
                if (!"true".equals(resource.getProperty("isActive"))) continue;
                resourceList.add(resource);
                String policyOrder = resource.getProperty("policyOrder");
                policyOrdering[i] = policyOrder != null ? Integer.parseInt(policyOrder) : 0;
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while retrieving active entitlement policies", (Throwable)e);
            throw new IdentityException("Error while retrieving active entitlement policies", (Throwable)e);
        }
        Resource[] resources = new Resource[resourceList.size()];
        if (resourceList.size() > 0) {
            int i;
            int[] tempArray = new int[policyOrdering.length];
            Arrays.sort(policyOrdering);
            for (i = 0; i < tempArray.length; ++i) {
                int j = policyOrdering.length - 1 - i;
                tempArray[j] = policyOrdering[i];
            }
            policyOrdering = tempArray;
            for (i = 0; i < policyOrdering.length; ++i) {
                for (Resource res : resourceList) {
                    String policyOrder = res.getProperty("policyOrder");
                    int order = 0;
                    if (policyOrder != null) {
                        order = Integer.parseInt(policyOrder);
                    }
                    if (policyOrdering[i] != order) continue;
                    resources[i] = res;
                }
            }
        }
        return resources;
    }

    public Resource[] getAllPolicies() throws IdentityException {
        String path = null;
        Collection collection = null;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        String[] children = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Retrieving all entitlement policies");
        }
        try {
            path = "/repository/identity/Entitlement/Policies/";
            if (!this.registry.resourceExists(path)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Trying to access an entitlement policy which does not exist");
                }
                return null;
            }
            collection = (Collection)this.registry.get(path);
            children = collection.getChildren();
            for (int i = 0; i < children.length; ++i) {
                resources.add(this.registry.get(children[i]));
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while retrieving entitlement policy", (Throwable)e);
            throw new IdentityException("Error while retrieving entitlement policies", (Throwable)e);
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    public String[] getAllPolicyIds() throws IdentityException {
        String path = null;
        Collection collection = null;
        ArrayList<String> resources = new ArrayList<String>();
        String[] children = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Retrieving all entitlement policies");
        }
        try {
            path = "/repository/identity/Entitlement/Policies/";
            if (!this.registry.resourceExists(path)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Trying to access an entitlement policy which does not exist");
                }
                return null;
            }
            collection = (Collection)this.registry.get(path);
            for (String child : children = collection.getChildren()) {
                String[] resourcePath = child.split("/");
                if (resourcePath == null || resourcePath.length <= 0) continue;
                resources.add(resourcePath[resourcePath.length - 1]);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while retrieving entitlement policy resources", (Throwable)e);
            throw new IdentityException("Error while retrieving entitlement policy resources", (Throwable)e);
        }
        return resources.toArray(new String[resources.size()]);
    }

    public Resource getPolicy(String policyId) throws IdentityException {
        String path = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Retrieving entitlement policy");
        }
        try {
            path = "/repository/identity/Entitlement/Policies/" + policyId;
            if (!this.registry.resourceExists(path)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Trying to access an entitlement policy which does not exist");
                }
                return null;
            }
            return this.registry.get(path);
        }
        catch (RegistryException e) {
            log.error((Object)"Error while retrieving entitlement policy", (Throwable)e);
            throw new IdentityException("Error while retrieving entitlement policy", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addOrUpdatePolicy(PolicyDTO policy) throws IdentityException {
        String path = null;
        Resource resource = null;
        AuthorizationManager authorizationManager = null;
        boolean newResource = false;
        boolean newPolicy = false;
        OMElement omElement = null;
        RealmService realmService = EntitlementServiceComponent.getRealmservice();
        String userName = ((UserRegistry)this.registry).getUserName();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating or updating entitlement policy");
        }
        if (policy == null || policy.getPolicyId() == null) {
            log.error((Object)"Error while creating or updating entitlement policy: Policy DTO or Policy Id can not be null");
            throw new IdentityException("Error while creating or updating entitlement policy: Policy DTO or Policy Id can not be null");
        }
        try {
            String[] policyMetaData;
            path = "/repository/identity/Entitlement/Policies/" + policy.getPolicyId();
            int tenantId = ((UserRegistry)this.registry).getTenantId();
            if (realmService == null) {
                log.error((Object)"Error while creating or updating entitlement policy: Realm Service can not be null");
                throw new IdentityException("Error while creating or updating entitlement policy: Realm Service can not be null");
            }
            authorizationManager = realmService.getTenantUserRealm(tenantId).getAuthorizationManager();
            if (authorizationManager == null) {
                log.error((Object)"Error while creating or updating entitlement policy: Authorization Manager can not be null");
                throw new IdentityException("Error while creating or updating entitlement policy: Authorization Manager can not be null");
            }
            if (!authorizationManager.isUserAuthorized(userName, "/permission/admin/configure", "ui.execute")) {
                log.error((Object)"User is not authorize to create or update entitlement policy");
                throw new IdentityException("User is not authorize to create or update entitlement policy");
            }
            authorizationManager.authorizeUser(userName, "/_system/governance/repository/identity/Entitlement/Policies/", "write");
            if (this.registry.resourceExists(path)) {
                resource = this.registry.get(path);
            } else {
                resource = this.registry.newResource();
                newResource = true;
            }
            Collection policyCollection = this.registry.resourceExists("/repository/identity/Entitlement/Policies/") ? (Collection)this.registry.get("/repository/identity/Entitlement/Policies/") : this.registry.newCollection();
            if (policy.getNeighborId() != null && policy.getNeighborId().trim().length() > 0) {
                String neighborPath = "/repository/identity/Entitlement/Policies/" + policy.getNeighborId();
                if (this.registry.resourceExists(neighborPath)) {
                    Resource neighborPolicy = this.registry.get(neighborPath);
                    String neighborPolicyOrder = neighborPolicy.getProperty("policyOrder");
                    if (neighborPolicyOrder != null) {
                        policy.setPolicyOrder(Integer.parseInt(neighborPolicyOrder));
                    }
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)"Invalid policy Id as neighbor policy id");
                }
            }
            if (policy.getPolicyOrder() > 0) {
                String noOfPolicies = policyCollection.getProperty("maxPolicyOrder");
                if (noOfPolicies != null && Integer.parseInt(noOfPolicies) < policy.getPolicyOrder()) {
                    policyCollection.setProperty("maxPolicyOrder", Integer.toString(policy.getPolicyOrder()));
                    this.registry.put("/repository/identity/Entitlement/Policies/", (Resource)policyCollection);
                } else {
                    this.reOrderPolicy(policyCollection, policy.getPolicyOrder());
                }
                resource.setProperty("policyOrder", Integer.toString(policy.getPolicyOrder()));
            } else {
                String previousOrder = resource.getProperty("policyOrder");
                if (previousOrder == null) {
                    if (policyCollection != null) {
                        int policyOrder = 1;
                        String noOfPolicies = policyCollection.getProperty("maxPolicyOrder");
                        if (noOfPolicies != null) {
                            policyOrder += Integer.parseInt(noOfPolicies);
                        }
                        policyCollection.setProperty("maxPolicyOrder", Integer.toString(policyOrder));
                        resource.setProperty("policyOrder", Integer.toString(policyOrder));
                    }
                    this.registry.put("/repository/identity/Entitlement/Policies/", (Resource)policyCollection);
                }
            }
            if (!newResource) {
                authorizationManager.clearUserAuthorization(userName, "/_system/governance/repository/identity/Entitlement/Policies/", "write");
            }
            if (policy.getPolicy() != null && policy.getPolicy().trim().length() > 0) {
                resource.setContent((Object)policy.getPolicy());
                newPolicy = true;
                PolicyMetaDataBuilder policyMetaDataBuilder = new PolicyMetaDataBuilder();
                Properties properties = policyMetaDataBuilder.getPolicyMetaDataFromPolicy(policy.getPolicy());
                for (Object o : properties.keySet()) {
                    String key = o.toString();
                    resource.setProperty(key, properties.getProperty(key));
                }
            }
            resource.setProperty("isActive", Boolean.toString(policy.isActive()));
            if (policy.getPolicyType() != null && policy.getPolicyType().trim().length() > 0) {
                resource.setProperty("policyType", policy.getPolicyType());
            } else {
                try {
                    if (newPolicy) {
                        omElement = AXIOMUtil.stringToOM((String)policy.getPolicy());
                        resource.setProperty("policyType", omElement.getLocalName());
                    }
                }
                catch (XMLStreamException e) {
                    policy.setPolicyType("Policy");
                    log.warn((Object)"Policy Type can not be found. Default type is set");
                }
            }
            if (omElement != null) {
                Iterator iterator2;
                Iterator iterator1 = omElement.getChildrenWithLocalName("policyIdReferences");
                if (iterator1 != null) {
                    String policyReferences = "";
                    while (iterator1.hasNext()) {
                        OMElement policyReference = (OMElement)iterator1.next();
                        if (!"".equals(policyReferences)) {
                            policyReferences = policyReferences + "," + policyReference.getText();
                            continue;
                        }
                        policyReferences = policyReference.getText();
                    }
                    resource.setProperty("policyIdReferences", policyReferences);
                }
                if ((iterator2 = omElement.getChildrenWithLocalName("policySetIdReferences")) != null) {
                    String policySetReferences = "";
                    while (iterator1.hasNext()) {
                        OMElement policySetReference = (OMElement)iterator2.next();
                        if (!"".equals(policySetReferences)) {
                            policySetReferences = policySetReferences + "," + policySetReference.getText();
                            continue;
                        }
                        policySetReferences = policySetReference.getText();
                    }
                    resource.setProperty("policySetIdReferences", policySetReferences);
                }
            }
            String policyEditor = resource.getProperty("policyEditor");
            if (newPolicy && policyEditor != null) {
                resource.removeProperty("policyEditor");
            }
            if (policy.getPolicyEditor() != null && policy.getPolicyEditor().trim().length() > 0) {
                resource.setProperty("policyEditor", policy.getPolicyEditor().trim());
            }
            if ((policyMetaData = policy.getBasicPolicyEditorMetaData()) != null && policyMetaData.length > 0) {
                String BasicPolicyEditorMetaDataAmount = resource.getProperty("NoOfBasicPolicyEditorMetaData");
                if (newPolicy && BasicPolicyEditorMetaDataAmount != null) {
                    int amount = Integer.parseInt(BasicPolicyEditorMetaDataAmount);
                    for (int i = 0; i < amount; ++i) {
                        resource.removeProperty("basicPolicyEditorMetaData" + i);
                    }
                    resource.removeProperty("NoOfBasicPolicyEditorMetaData");
                }
                int i = 0;
                String[] arr$ = policyMetaData;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i, ++i$) {
                    String policyData = arr$[i$];
                    if (policyData == null || "".equals(policyData)) continue;
                    resource.setProperty("basicPolicyEditorMetaData" + i, policyData);
                }
                resource.setProperty("NoOfBasicPolicyEditorMetaData", Integer.toString(i));
            }
            this.registry.put(path, resource);
            authorizationManager.clearUserAuthorization(userName, "/_system/governance/repository/identity/Entitlement/Policies/", "write");
            authorizationManager.authorizeUser(userName, "/_system/governance" + path, "write");
            authorizationManager.authorizeUser(userName, "/_system/governance" + path, "delete");
            return;
        }
        catch (RegistryException e) {
            log.error((Object)"Error while adding or updating entitlement policy", (Throwable)e);
            throw new IdentityException("Error while adding or updating entitlement policy", (Throwable)e);
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while adding or updating entitlement policy", (Throwable)e);
            throw new IdentityException("Error while adding or updating entitlement policy", (Throwable)e);
        }
    }

    private void reOrderPolicy(Collection collection, int orderNo) throws IdentityException {
        try {
            String[] resources = collection.getChildren();
            for (int i = 0; i < resources.length; ++i) {
                int currentOrder;
                Resource resource = this.registry.get(resources[i]);
                String policyOrder = resource.getProperty("policyOrder");
                if (policyOrder == null || orderNo > (currentOrder = Integer.parseInt(policyOrder))) continue;
                resource.setProperty("policyOrder", Integer.toString(++currentOrder));
                this.registry.put(resources[i], resource);
                String maxPolicyOrder = collection.getProperty("maxPolicyOrder");
                if (maxPolicyOrder == null || Integer.parseInt(maxPolicyOrder) >= currentOrder) continue;
                collection.setProperty("maxPolicyOrder", Integer.toString(currentOrder));
                this.registry.put("/repository/identity/Entitlement/Policies/", (Resource)collection);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while re-ordering entitlement policy", (Throwable)e);
            throw new IdentityException("Error while re-ordering entitlement policy", (Throwable)e);
        }
    }

    public void removePolicy(String policyId) throws IdentityException {
        String path = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Removing entitlement policy");
        }
        try {
            path = "/repository/identity/Entitlement/Policies/" + policyId;
            if (!this.registry.resourceExists(path)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Trying to access an entitlement policy which does not exist");
                }
                return;
            }
            this.registry.delete(path);
        }
        catch (RegistryException e) {
            log.error((Object)"Error while removing entitlement policy", (Throwable)e);
            throw new IdentityException("Error while removing policy", (Throwable)e);
        }
    }

    public Resource getEntitlementPolicyResources(String resourceName) throws IdentityException {
        String path = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Retrieving entitlement policy resources");
        }
        try {
            path = "/repository/identity/Entitlement/resources/" + resourceName;
            if (!this.registry.resourceExists(path)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Trying to access an entitlement policy resource which does not exist");
                }
                return null;
            }
            return this.registry.get(path);
        }
        catch (RegistryException e) {
            log.error((Object)"Error while retrieving entitlement policy resources", (Throwable)e);
            throw new IdentityException("Error while retrieving entitlement policy resources", (Throwable)e);
        }
    }

    public void addPolicyCombiningAlgorithm(String policyCombiningAlgorithm) throws IdentityException {
        try {
            Collection policyCollection = this.registry.resourceExists("/repository/identity/Entitlement/Policies/") ? (Collection)this.registry.get("/repository/identity/Entitlement/Policies/") : this.registry.newCollection();
            policyCollection.setProperty("globalPolicyCombiningAlgorithm", policyCombiningAlgorithm);
            this.registry.put("/repository/identity/Entitlement/Policies/", (Resource)policyCollection);
        }
        catch (RegistryException e) {
            log.error((Object)"Error while writing entitlement policy resources", (Throwable)e);
            throw new IdentityException("Error while writing entitlement policy resources", (Throwable)e);
        }
    }

    public Collection getPolicyCollection() throws IdentityException {
        try {
            if (this.registry.resourceExists("/repository/identity/Entitlement/Policies/")) {
                return (Collection)this.registry.get("/repository/identity/Entitlement/Policies/");
            }
            return null;
        }
        catch (RegistryException e) {
            log.error((Object)"Error while reading policy collection", (Throwable)e);
            throw new IdentityException("Error while reading policy collection", (Throwable)e);
        }
    }

    public Registry getRegistry() {
        return this.registry;
    }
}

