/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy;

import java.io.ByteArrayInputStream;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wso2.balana.AbstractPolicy;
import org.wso2.balana.ParsingException;
import org.wso2.balana.Policy;
import org.wso2.balana.PolicySet;
import org.wso2.balana.finder.PolicyFinder;
import org.wso2.carbon.identity.entitlement.policy.PolicyTarget;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PolicyReader
implements ErrorHandler {
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static Log log = LogFactory.getLog(PolicyReader.class);
    private static volatile PolicyReader reader;
    private static Object lock;
    private DocumentBuilder builder;
    private PolicyFinder policyFinder;

    private PolicyReader(File schemaFile, PolicyFinder policyFinder) {
        this.policyFinder = policyFinder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setNamespaceAware(true);
        if (schemaFile == null) {
            factory.setValidating(false);
        } else {
            factory.setValidating(true);
            factory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            factory.setAttribute(JAXP_SCHEMA_SOURCE, schemaFile);
        }
        try {
            this.builder = factory.newDocumentBuilder();
            this.builder.setErrorHandler(this);
        }
        catch (ParserConfigurationException pce) {
            throw new IllegalArgumentException("Filed to setup reader: ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PolicyReader getInstance(File schemaFile, PolicyFinder policyFinder) {
        if (reader == null) {
            Object object = lock;
            synchronized (object) {
                if (reader == null) {
                    reader = new PolicyReader(schemaFile, policyFinder);
                }
            }
        }
        return reader;
    }

    public boolean isValidPolicy(String policy) {
        ByteArrayInputStream stream = null;
        try {
            stream = new ByteArrayInputStream(policy.getBytes("UTF-8"));
            this.handleDocument(this.builder.parse(stream));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public AbstractPolicy getPolicy(String policy) {
        ByteArrayInputStream stream = null;
        try {
            stream = new ByteArrayInputStream(policy.getBytes("UTF-8"));
            return this.handleDocument(this.builder.parse(stream));
        }
        catch (Exception e) {
            log.error((Object)"Error while parsing the policy", (Throwable)e);
            return null;
        }
    }

    public PolicyTarget getTarget(String policy) {
        ByteArrayInputStream stream = null;
        PolicyTarget policyTarget = new PolicyTarget();
        try {
            stream = new ByteArrayInputStream(policy.getBytes("UTF-8"));
            AbstractPolicy abstractPolicy = this.handleDocument(this.builder.parse(stream));
            policyTarget.setTarget(abstractPolicy.getTarget());
            policyTarget.setPolicyId(abstractPolicy.getId().toString());
            return policyTarget;
        }
        catch (Exception e) {
            log.error((Object)"Error while parsing the policy", (Throwable)e);
            return null;
        }
    }

    private AbstractPolicy handleDocument(Document doc) throws ParsingException {
        Element root = doc.getDocumentElement();
        String name = root.getTagName();
        if (name.equals("Policy")) {
            return Policy.getInstance((Node)root);
        }
        if (name.equals("PolicySet")) {
            return PolicySet.getInstance((Node)root, (PolicyFinder)this.policyFinder);
        }
        throw new ParsingException("Unknown root document type: " + name);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        if (log.isWarnEnabled()) {
            String message = null;
            message = "Warning on line " + exception.getLineNumber() + ": " + exception.getMessage();
            log.warn((Object)message);
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        if (log.isWarnEnabled()) {
            log.warn((Object)("Error on line " + exception.getLineNumber() + ": " + exception.getMessage() + " ... " + "Policy will not be available"));
        }
        throw new SAXException("error parsing policy");
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        if (log.isWarnEnabled()) {
            log.warn((Object)("Fatal error on line " + exception.getLineNumber() + ": " + exception.getMessage() + " ... " + "Policy will not be available"));
        }
        throw new SAXException("fatal error parsing policy");
    }

    static {
        lock = new Object();
    }
}

