/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.pip;

import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jsr107cache.Cache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.finder.ResourceFinderModule;
import org.wso2.balana.finder.ResourceFinderResult;
import org.wso2.carbon.caching.core.identity.IdentityCacheEntry;
import org.wso2.carbon.caching.core.identity.IdentityCacheKey;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.entitlement.EntitlementUtil;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.pip.PIPResourceFinder;

public class CarbonResourceFinder
extends ResourceFinderModule {
    private int tenantId;
    private Set<PIPResourceFinder> resourceFinders = new HashSet<PIPResourceFinder>();
    private Cache resourceCache = null;
    boolean isResourceCachingEnabled = false;
    private static Log log = LogFactory.getLog(CarbonResourceFinder.class);

    public CarbonResourceFinder(int tenantId) {
        this.tenantId = tenantId;
    }

    public void init() {
        Properties properties;
        Map<PIPResourceFinder, Properties> resourceConfigs = EntitlementServiceComponent.getEntitlementConfig().getResourceFinders();
        if (resourceConfigs != null && !resourceConfigs.isEmpty()) {
            this.resourceFinders = resourceConfigs.keySet();
        }
        if ("true".equals((properties = EntitlementServiceComponent.getEntitlementConfig().getCachingProperties()).getProperty("ResourceCaching.Enable"))) {
            this.resourceCache = EntitlementUtil.getCommonCache("PIP_RESOURCE_CACHE");
            this.isResourceCachingEnabled = true;
        }
    }

    public boolean isChildSupported() {
        return true;
    }

    public boolean isDescendantSupported() {
        return true;
    }

    public ResourceFinderResult findDescendantResources(AttributeValue parentResourceId, EvaluationCtx context) {
        ResourceFinderResult resourceFinderResult = null;
        HashSet<AttributeValue> resources = null;
        String dataType = parentResourceId.getType().toString();
        for (PIPResourceFinder finder : this.resourceFinders) {
            try {
                Set<String> resourceNames = null;
                if (this.isResourceCachingEnabled && !finder.overrideDefaultCache()) {
                    IdentityCacheKey cacheKey = null;
                    String key = "Descendants" + parentResourceId.encode() + this.domToString(context.getRequestRoot());
                    cacheKey = new IdentityCacheKey(this.tenantId, key);
                    IdentityCacheEntry cacheEntry = (IdentityCacheEntry)this.resourceCache.get((Object)cacheKey);
                    if (cacheEntry != null) {
                        String[] values = cacheEntry.getCacheEntryArray();
                        resourceNames = new HashSet<String>(Arrays.asList(values));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Carbon Resource Cache Hit");
                        }
                    }
                    if (resourceNames != null) {
                        resourceNames = finder.findDescendantResources(parentResourceId.encode(), context);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Carbon Resource Cache Miss");
                        }
                        cacheEntry = new IdentityCacheEntry(resourceNames.toArray(new String[resourceNames.size()]));
                        this.resourceCache.put((Object)cacheKey, (Object)cacheEntry);
                    }
                } else {
                    resourceNames = finder.findDescendantResources(parentResourceId.encode(), context);
                }
                if (resourceNames == null || resourceNames.isEmpty()) continue;
                resources = new HashSet<AttributeValue>();
                for (String resourceName : resourceNames) {
                    resources.add(EntitlementUtil.getAttributeValue(resourceName, dataType));
                }
            }
            catch (IdentityException e) {
                log.error((Object)"Error while finding descendant resources", (Throwable)e);
            }
            catch (TransformerException e) {
                log.error((Object)"Error while finding descendant resources", (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)"Error while finding descendant resources", (Throwable)e);
            }
        }
        resourceFinderResult = resources != null ? new ResourceFinderResult(resources) : new ResourceFinderResult();
        return resourceFinderResult;
    }

    public ResourceFinderResult findChildResources(AttributeValue parentResourceId, EvaluationCtx context) {
        ResourceFinderResult resourceFinderResult = null;
        HashSet<AttributeValue> resources = null;
        String dataType = parentResourceId.getType().toString();
        for (PIPResourceFinder finder : this.resourceFinders) {
            try {
                Set<String> resourceNames = null;
                if (this.isResourceCachingEnabled && !finder.overrideDefaultCache()) {
                    String cacheEntryString;
                    IdentityCacheKey cacheKey = null;
                    String key = "Children" + parentResourceId.encode() + this.domToString(context.getRequestRoot());
                    cacheKey = new IdentityCacheKey(this.tenantId, key);
                    IdentityCacheEntry cacheEntry = (IdentityCacheEntry)this.resourceCache.get((Object)cacheKey);
                    if (cacheEntry != null) {
                        cacheEntryString = cacheEntry.getCacheEntry();
                        String[] attributes = cacheEntryString.split(",");
                        if (attributes != null && attributes.length > 0) {
                            List<String> list = Arrays.asList(attributes);
                            resourceNames = new HashSet<String>(list);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Carbon Resource Cache Hit");
                        }
                    } else {
                        resourceNames = finder.findChildResources(parentResourceId.encode(), context);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Carbon Resource Cache Miss");
                        }
                        cacheEntryString = "";
                        if (resourceNames != null && resourceNames.size() > 0) {
                            for (String attribute : resourceNames) {
                                if (cacheEntryString.equals("")) {
                                    cacheEntryString = attribute;
                                    continue;
                                }
                                cacheEntryString = cacheEntryString + "," + attribute;
                            }
                        }
                        cacheEntry = new IdentityCacheEntry(cacheEntryString);
                        this.resourceCache.put((Object)cacheKey, (Object)cacheEntry);
                    }
                } else {
                    resourceNames = finder.findChildResources(parentResourceId.encode(), context);
                }
                if (resourceNames == null || resourceNames.isEmpty()) continue;
                resources = new HashSet<AttributeValue>();
                for (String resourceName : resourceNames) {
                    resources.add(EntitlementUtil.getAttributeValue(resourceName, dataType));
                }
            }
            catch (IdentityException e) {
                log.error((Object)"Error while finding child resources", (Throwable)e);
            }
            catch (TransformerException e) {
                log.error((Object)"Error while finding child resources", (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)"Error while finding child resources", (Throwable)e);
            }
        }
        resourceFinderResult = resources != null ? new ResourceFinderResult(resources) : new ResourceFinderResult();
        return resourceFinderResult;
    }

    public void disableAttributeCache() {
        this.resourceCache = null;
    }

    public void enableAttributeCache() {
        this.resourceCache = EntitlementUtil.getCommonCache("PIP_RESOURCE_CACHE");
    }

    public void clearAttributeCache() {
        if (this.resourceCache != null) {
            this.resourceCache.clear();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource cache is cleared for tenant " + this.tenantId));
            }
        }
    }

    private String domToString(Node node) throws TransformerException {
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        StringWriter buffer = new StringWriter();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new DOMSource(node), new StreamResult(buffer));
        return buffer.toString();
    }
}

