/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.pip;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import net.sf.jsr107cache.Cache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.BagAttribute;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.carbon.caching.core.identity.IdentityCacheEntry;
import org.wso2.carbon.caching.core.identity.IdentityCacheKey;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.entitlement.EntitlementUtil;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.pip.PIPAttributeFinder;

public abstract class AbstractPIPAttributeFinder
implements PIPAttributeFinder {
    private static Log log = LogFactory.getLog(AbstractPIPAttributeFinder.class);
    private Cache abstractAttributeFinderCache = null;
    private boolean isAbstractAttributeCachingEnabled = false;
    private int tenantId;

    public abstract Set<String> getAttributeValues(String var1, String var2, String var3, String var4, String var5, String var6) throws Exception;

    @Override
    public Set<String> getAttributeValues(URI attributeType, URI attributeId, URI category, String issuer, EvaluationCtx evaluationCtx) throws Exception {
        EvaluationResult environment;
        EvaluationResult action;
        EvaluationResult resource;
        BagAttribute bagAttribute;
        String subjectId = null;
        String resourceId = null;
        String actionId = null;
        String environmentId = null;
        Set<String> attributeValues = null;
        EvaluationResult subject = evaluationCtx.getAttribute(new URI("http://www.w3.org/2001/XMLSchema#string"), new URI("urn:oasis:names:tc:xacml:1.0:subject:subject-id"), issuer, new URI("urn:oasis:names:tc:xacml:1.0:subject-category:access-subject"));
        if (subject != null && subject.getAttributeValue() != null && subject.getAttributeValue().isBag() && (bagAttribute = (BagAttribute)subject.getAttributeValue()).size() > 0) {
            subjectId = ((AttributeValue)bagAttribute.iterator().next()).encode();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Finding attributes for the subject %1$s", subjectId));
            }
        }
        if ((resource = evaluationCtx.getAttribute(new URI("http://www.w3.org/2001/XMLSchema#string"), new URI("urn:oasis:names:tc:xacml:1.0:resource:resource-id"), issuer, new URI("urn:oasis:names:tc:xacml:3.0:attribute-category:resource"))) != null && resource.getAttributeValue() != null && resource.getAttributeValue().isBag() && (bagAttribute = (BagAttribute)resource.getAttributeValue()).size() > 0) {
            resourceId = ((AttributeValue)bagAttribute.iterator().next()).encode();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Finding attributes for the resource %1$s", resourceId));
            }
        }
        if ((action = evaluationCtx.getAttribute(new URI("http://www.w3.org/2001/XMLSchema#string"), new URI("urn:oasis:names:tc:xacml:1.0:action:action-id"), issuer, new URI("urn:oasis:names:tc:xacml:3.0:attribute-category:action"))) != null && action.getAttributeValue() != null && action.getAttributeValue().isBag() && (bagAttribute = (BagAttribute)action.getAttributeValue()).size() > 0) {
            actionId = ((AttributeValue)bagAttribute.iterator().next()).encode();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Finding attributes for the action %1$s", actionId));
            }
        }
        if ((environment = evaluationCtx.getAttribute(new URI("http://www.w3.org/2001/XMLSchema#string"), new URI("urn:oasis:names:tc:xacml:1.0:environment:environment-id"), issuer, new URI("urn:oasis:names:tc:xacml:3.0:attribute-category:environment"))) != null && environment.getAttributeValue() != null && environment.getAttributeValue().isBag() && (bagAttribute = (BagAttribute)environment.getAttributeValue()).size() > 0) {
            environmentId = ((AttributeValue)bagAttribute.iterator().next()).encode();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Finding attributes for the environment %1$s", environmentId));
            }
        }
        IdentityCacheKey cacheKey = null;
        if (this.isAbstractAttributeCachingEnabled) {
            IdentityCacheEntry entry;
            String key = (subjectId != null ? subjectId : "") + (resourceId != null ? resourceId : "") + (environmentId != null ? environmentId : "") + (attributeId != null ? attributeId : "") + (issuer != null ? issuer : "") + (actionId != null ? actionId : "");
            this.tenantId = CarbonContext.getCurrentContext().getTenantId();
            cacheKey = new IdentityCacheKey(this.tenantId, key);
            if (cacheKey != null && (entry = (IdentityCacheEntry)this.abstractAttributeFinderCache.get((Object)cacheKey)) != null) {
                String[] values = entry.getCacheEntryArray();
                attributeValues = new HashSet<String>(Arrays.asList(values));
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Carbon Attribute Cache Hit");
                }
            }
        }
        if (attributeValues == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Carbon Attribute Cache Miss");
            }
            attributeValues = this.getAttributeValues(subjectId, resourceId, actionId, environmentId, attributeId.toString(), issuer);
            if (this.isAbstractAttributeCachingEnabled && cacheKey != null && attributeValues != null && !attributeValues.isEmpty()) {
                IdentityCacheEntry cacheEntry = new IdentityCacheEntry(attributeValues.toArray(new String[attributeValues.size()]));
                this.abstractAttributeFinderCache.put((Object)cacheKey, (Object)cacheEntry);
            }
        }
        return attributeValues;
    }

    @Override
    public boolean overrideDefaultCache() {
        Properties properties = EntitlementServiceComponent.getEntitlementConfig().getCachingProperties();
        if ("true".equals(properties.getProperty("AttributeCaching.Enable"))) {
            this.abstractAttributeFinderCache = EntitlementUtil.getCommonCache("PIP_ABSTRACT_ATTRIBUTE_CACHE");
            this.isAbstractAttributeCachingEnabled = true;
            return true;
        }
        return false;
    }

    @Override
    public void clearCache() {
        if (this.abstractAttributeFinderCache != null) {
            this.abstractAttributeFinderCache.clear();
        }
    }

    @Override
    public void clearCache(String[] attributeId) {
    }
}

