/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.dto;

import java.util.Arrays;
import java.util.HashSet;

public class AttributeValueTreeNodeDTO {
    private String name;
    private String categoryId;
    private String categoryUri;
    private String[] attributeDataTypes = new String[0];
    private String[] supportedAttributeIds = new String[0];
    private boolean fullPathSupported;
    private boolean hierarchicalTree;
    private String moduleName;
    private AttributeValueTreeNodeDTO[] childNodes = new AttributeValueTreeNodeDTO[0];
    private String defaultAttributeDataType;
    private String defaultAttributeId;

    public AttributeValueTreeNodeDTO(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryUri() {
        return this.categoryUri;
    }

    public void setCategoryUri(String categoryUri) {
        this.categoryUri = categoryUri;
    }

    public AttributeValueTreeNodeDTO[] getChildNodes() {
        return Arrays.copyOf(this.childNodes, this.childNodes.length);
    }

    public boolean isFullPathSupported() {
        return this.fullPathSupported;
    }

    public void setFullPathSupported(boolean fullPathSupported) {
        this.fullPathSupported = fullPathSupported;
    }

    public boolean isHierarchicalTree() {
        return this.hierarchicalTree;
    }

    public void setHierarchicalTree(boolean hierarchicalTree) {
        this.hierarchicalTree = hierarchicalTree;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String[] getAttributeDataTypes() {
        return Arrays.copyOf(this.attributeDataTypes, this.attributeDataTypes.length);
    }

    public void setAttributeDataTypes(String[] attributeDataTypes) {
        this.attributeDataTypes = Arrays.copyOf(attributeDataTypes, attributeDataTypes.length);
    }

    public void setSupportedAttributeIds(String[] supportedAttributeIds) {
        this.supportedAttributeIds = Arrays.copyOf(supportedAttributeIds, supportedAttributeIds.length);
    }

    public void addAttributeDataType(String attributeDataType) {
        HashSet<String> attributeDataTypes = new HashSet<String>(Arrays.asList(this.attributeDataTypes));
        attributeDataTypes.add(attributeDataType);
        this.attributeDataTypes = attributeDataTypes.toArray(new String[attributeDataTypes.size()]);
    }

    public void setChildNodes(AttributeValueTreeNodeDTO[] childNodes) {
        this.childNodes = Arrays.copyOf(childNodes, childNodes.length);
    }

    public void addChildNode(AttributeValueTreeNodeDTO node) {
        HashSet<AttributeValueTreeNodeDTO> valueNodes = new HashSet<AttributeValueTreeNodeDTO>(Arrays.asList(this.childNodes));
        valueNodes.add(node);
        this.childNodes = valueNodes.toArray(new AttributeValueTreeNodeDTO[valueNodes.size()]);
    }

    public String[] getSupportedAttributeIds() {
        return Arrays.copyOf(this.supportedAttributeIds, this.supportedAttributeIds.length);
    }

    public void addSupportedAttributeId(String supportedAttributeId) {
        HashSet<String> attributeIds = new HashSet<String>(Arrays.asList(this.supportedAttributeIds));
        attributeIds.add(supportedAttributeId);
        this.supportedAttributeIds = attributeIds.toArray(new String[attributeIds.size()]);
    }

    public String getDefaultAttributeDataType() {
        return this.defaultAttributeDataType;
    }

    public void setDefaultAttributeDataType(String defaultAttributeDataType) {
        this.defaultAttributeDataType = defaultAttributeDataType;
    }

    public String getDefaultAttributeId() {
        return this.defaultAttributeId;
    }

    public void setDefaultAttributeId(String defaultAttributeId) {
        this.defaultAttributeId = defaultAttributeId;
    }
}

