/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.identity.entitlement.pdp.EntitlementEngine;

public class EntitlementService
extends AbstractAdmin {
    private static Log log = LogFactory.getLog(EntitlementService.class);

    public String getDecision(String request) throws Exception {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("XACML Request  :  " + request));
            }
            EntitlementEngine entitlementEngine = EntitlementEngine.getInstance(this.getGovernanceUserRegistry(), CarbonContext.getCurrentContext().getTenantId());
            String response = entitlementEngine.evaluate(request);
            if (log.isDebugEnabled()) {
                log.debug((Object)("XACML Response  :  " + response));
            }
            return response;
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while evaluating XACML request", (Throwable)e);
            throw new Exception("Error occurred while evaluating XACML request");
        }
    }

    public String getDecisionByAttributes(String subject, String resource, String action, String[] environment) throws Exception {
        String realEnvironment = null;
        if (environment != null && environment.length > 0) {
            realEnvironment = environment[0];
        }
        try {
            EntitlementEngine entitlementEngine = EntitlementEngine.getInstance(this.getGovernanceUserRegistry(), CarbonContext.getCurrentContext().getTenantId());
            return entitlementEngine.evaluate(subject, resource, action, realEnvironment);
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while evaluating XACML request", (Throwable)e);
            throw new Exception("Error occurred while evaluating XACML request");
        }
    }
}

