/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.webseal.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.core.common.IAuthenticationAdmin;
import org.wso2.carbon.core.common.IFileDownload;
import org.wso2.carbon.core.common.IFileUpload;
import org.wso2.carbon.core.services.authentication.AuthenticationAdmin;
import org.wso2.carbon.core.services.callback.LoginSubscriptionManagerService;
import org.wso2.carbon.core.services.callback.LoginSubscriptionManagerServiceImpl;
import org.wso2.carbon.core.services.filedownload.FileDownloadService;
import org.wso2.carbon.core.services.fileupload.FileUploadService;
import org.wso2.carbon.identity.authenticator.webseal.internal.WebSealAuthBEDataHolder;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;

public class WebSealAuthenticatorDSComponent {
    private static LoginSubscriptionManagerServiceImpl loginSubscriptionManagerServiceImpl = new LoginSubscriptionManagerServiceImpl();
    private static final Log log = LogFactory.getLog(WebSealAuthenticatorDSComponent.class);

    protected void activate(ComponentContext ctxt) {
        try {
            BundleContext bc = ctxt.getBundleContext();
            bc.registerService(IAuthenticationAdmin.class.getName(), (Object)new AuthenticationAdmin(), null);
            bc.registerService(IFileUpload.class.getName(), (Object)new FileUploadService(), null);
            bc.registerService(IFileDownload.class.getName(), (Object)new FileDownloadService(), null);
            bc.registerService(LoginSubscriptionManagerService.class.getName(), (Object)loginSubscriptionManagerServiceImpl, null);
            log.debug((Object)"Carbon Core Services bundle is activated ");
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate Carbon Core Services bundle ", e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        log.debug((Object)"Carbon Core Services bundle is deactivated ");
    }

    protected void setRegistryService(RegistryService registryService) {
        WebSealAuthBEDataHolder.getInstance().setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        WebSealAuthBEDataHolder.getInstance().setRegistryService(null);
    }

    protected void setRealmService(RealmService realmService) {
        WebSealAuthBEDataHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        WebSealAuthBEDataHolder.getInstance().setRealmService(null);
    }
}

