/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.webseal;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.common.AuthenticationException;
import org.wso2.carbon.core.services.util.CarbonAuthenticationUtil;
import org.wso2.carbon.core.util.AnonymousSessionUtil;
import org.wso2.carbon.identity.authenticator.webseal.internal.WebSealAuthBEDataHolder;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class WebSealAuthenticator {
    private static final Log log = LogFactory.getLog(WebSealAuthenticator.class);

    public boolean loginWithDelegation(String username, String password, String authenticatedUser, String remoteAddress) throws AuthenticationException {
        HttpSession httpSess = this.getHttpSession();
        try {
            if (username == null || password == null || remoteAddress == null || username.trim().equals("") || password.trim().equals("") || remoteAddress.trim().equals("")) {
                CarbonAuthenticationUtil.onFailedAdminLogin((HttpSession)httpSess, (String)username, (int)-1, (String)remoteAddress, (String)"Data");
                return false;
            }
            RegistryService registryService = WebSealAuthBEDataHolder.getInstance().getRegistryService();
            RealmService realmService = WebSealAuthBEDataHolder.getInstance().getRealmService();
            String tenantDomain = MultitenantUtils.getTenantDomain((String)username);
            username = MultitenantUtils.getTenantAwareUsername((String)username);
            UserRealm realm = AnonymousSessionUtil.getRealmByTenantDomain((RegistryService)registryService, (RealmService)realmService, (String)tenantDomain);
            boolean isAuthenticated = realm.getUserStoreManager().authenticate(username, (Object)password);
            if (!isAuthenticated) {
                CarbonAuthenticationUtil.onFailedAdminLogin((HttpSession)httpSess, (String)username, (int)-1, (String)remoteAddress, (String)"Data");
                return false;
            }
            boolean isDelegateToAuthorized = realm.getAuthorizationManager().isUserAuthorized(username, "System", "delegate-identity");
            boolean isLoginToAuthorized = realm.getAuthorizationManager().isUserAuthorized(authenticatedUser, "System", "login");
            int tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
            if (isDelegateToAuthorized && isLoginToAuthorized) {
                CarbonAuthenticationUtil.onSuccessAdminLogin((HttpSession)httpSess, (String)username, (int)tenantId, (String)tenantDomain, (String)remoteAddress);
                log.info((Object)("Identity delegation by " + username + " on behalf of " + authenticatedUser + " from IP address " + remoteAddress));
                return true;
            }
            CarbonAuthenticationUtil.onFailedAdminLogin((HttpSession)httpSess, (String)username, (int)-1, (String)remoteAddress, (String)"User is not authorized to login using delegation");
            return false;
        }
        catch (Exception e) {
            String msg = "System error while Authenticating/Authorizing User with identity delegation";
            log.error((Object)msg, (Throwable)e);
            return false;
        }
    }

    private HttpSession getHttpSession() {
        MessageContext msgCtx = MessageContext.getCurrentMessageContext();
        HttpSession httpSess = null;
        if (msgCtx != null) {
            HttpServletRequest request = (HttpServletRequest)msgCtx.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            httpSess = request.getSession();
        }
        return httpSess;
    }
}

