/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.webseal.ui;

import java.rmi.RemoteException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axiom.om.util.Base64;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.common.AuthenticationException;
import org.wso2.carbon.core.security.AuthenticatorsConfiguration;
import org.wso2.carbon.identity.authenticator.webseal.stub.client.WebSealAuthenticatorStub;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.ui.DefaultCarbonAuthenticator;

public class WebSealUIAuthenticator
extends DefaultCarbonAuthenticator {
    public static final String WEBSEAL_USER = "iv-user";
    protected static final Log log = LogFactory.getLog(WebSealUIAuthenticator.class);
    private static final int DEFAULT_PRIORITY_LEVEL = 10;
    private static final String AUTHENTICATOR_NAME = "WebSealUIAuthenticator";

    public boolean isHandle(Object object) {
        if (!(object instanceof HttpServletRequest)) {
            return false;
        }
        HttpServletRequest request = (HttpServletRequest)object;
        String ivuser = request.getHeader(WEBSEAL_USER);
        return ivuser != null;
    }

    public int getPriority() {
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(AUTHENTICATOR_NAME);
        if (authenticatorConfig != null && authenticatorConfig.getPriority() > 0) {
            return authenticatorConfig.getPriority();
        }
        return 10;
    }

    public String getAuthenticatorName() {
        return AUTHENTICATOR_NAME;
    }

    public boolean authenticate(Object object) throws AuthenticationException {
        HttpServletRequest request = (HttpServletRequest)object;
        String credentials = request.getHeader("Authorization");
        String websealuser = null;
        String password = null;
        String username = request.getHeader(WEBSEAL_USER);
        if (credentials == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Empty Authorization header");
            }
            return false;
        }
        credentials = credentials.trim();
        if (credentials != null && credentials.startsWith("Basic ")) {
            int i = (credentials = new String(Base64.decode((String)credentials.substring(6)))).indexOf(58);
            websealuser = i == -1 ? credentials : credentials.substring(0, i);
            if (i != -1 && (password = credentials.substring(i + 1)) != null && password.equals("")) {
                password = null;
            }
        }
        try {
            return this.authenticate(request, websealuser, password, username);
        }
        catch (RemoteException e) {
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean authenticate(HttpServletRequest request, String websealUser, String password, String userName) throws RemoteException {
        try {
            if (websealUser == null || password == null) {
                if (log.isDebugEnabled()) {
                    if (websealUser == null) {
                        log.debug((Object)"No valid webseal user name provided");
                    }
                    if (password == null) {
                        log.debug((Object)"No valid webseal user password provided");
                    }
                    if (password == null) {
                        log.debug((Object)"No valid webseal authneticated user name provided");
                    }
                }
                return false;
            }
            ServletContext servletContext = request.getSession().getServletContext();
            ConfigurationContext configContext = (ConfigurationContext)servletContext.getAttribute("ConfigurationContext");
            if (configContext == null) {
                log.error((Object)"Configuration context is null.");
            }
            HttpSession session = request.getSession();
            String backendServerURL = request.getParameter("backendURL");
            if (backendServerURL == null) {
                backendServerURL = CarbonUIUtil.getServerURL((ServletContext)servletContext, (HttpSession)request.getSession());
            }
            session.setAttribute("ServerURL", (Object)backendServerURL);
            boolean isLogged = false;
            String serviceEPR = backendServerURL + "WebSealAuthenticator";
            WebSealAuthenticatorStub stub = new WebSealAuthenticatorStub(configContext, serviceEPR);
            ServiceClient client = stub._getServiceClient();
            Options options = client.getOptions();
            options.setManageSession(true);
            return isLogged;
        }
        catch (AxisFault axisFault) {
            throw axisFault;
        }
        catch (Exception e) {
            throw new AxisFault("Exception occured", (Throwable)e);
        }
    }

    public boolean isDisabled() {
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(AUTHENTICATOR_NAME);
        if (authenticatorConfig != null) {
            return authenticatorConfig.isDisabled();
        }
        return false;
    }

    public boolean reAuthenticateOnSessionExpire(Object object) throws AuthenticationException {
        return false;
    }
}

