/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.sso.ui;

import java.rmi.RemoteException;
import javax.servlet.http.HttpServletRequest;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.common.AuthenticationException;
import org.wso2.carbon.ui.DefaultCarbonAuthenticator;

public class SSOUIAuthenticator
extends DefaultCarbonAuthenticator {
    public static final String SSO_SESSION_ID = "ssoSessionId";
    private static final int DEFAULT_PRIORITY_LEVEL = 15;
    private static final String AUTHENTICATOR_NAME = "Authenticators.SSOUIAuthenticator";
    private static final String AUTHENTICATOR_PRIOROTY = "Authenticators.SSOUIAuthenticator.Priority";
    private static final String AUTHENTICATOR_DISABLED = "Authenticators.SSOUIAuthenticator.Disabled";

    public boolean authenticate(Object object) throws AuthenticationException {
        String userName = null;
        String ssoSessionId = null;
        HttpServletRequest request = (HttpServletRequest)object;
        userName = request.getParameter("username");
        ssoSessionId = request.getParameter(SSO_SESSION_ID);
        try {
            return super.authenticate(request, userName, ssoSessionId, false);
        }
        catch (RemoteException e) {
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isHandle(Object object) {
        if (!(object instanceof HttpServletRequest)) {
            return false;
        }
        HttpServletRequest request = (HttpServletRequest)object;
        String password = request.getParameter("password");
        String ssoSessionId = request.getParameter(SSO_SESSION_ID);
        return ssoSessionId != null && password == null;
    }

    public int getPriority() {
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        String priority = serverConfig.getFirstProperty(AUTHENTICATOR_PRIOROTY);
        if (priority != null && priority.length() > 0) {
            return Integer.parseInt(priority);
        }
        return 15;
    }

    public String getAuthenticatorName() {
        return AUTHENTICATOR_NAME;
    }

    public boolean isDisabled() {
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        String isDisabled = serverConfig.getFirstProperty(AUTHENTICATOR_DISABLED);
        if (isDisabled != null && isDisabled.length() > 0) {
            return Boolean.getBoolean(isDisabled);
        }
        return false;
    }
}

