/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.token;

import java.security.SignatureException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axiom.om.util.Base64;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.common.AuthenticationException;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.core.security.AuthenticatorsConfiguration;
import org.wso2.carbon.core.services.authentication.AuthenticationAdmin;
import org.wso2.carbon.core.services.authentication.CarbonServerAuthenticator;
import org.wso2.carbon.identity.authenticator.token.internal.TokenAuthBEDataHolder;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class TokenAuthenticator
extends AbstractAdmin
implements CarbonServerAuthenticator {
    private static final Log log = LogFactory.getLog(TokenAuthenticator.class);
    private static final int DEFAULT_PRIORITY_LEVEL = -5;
    private static final String AUTHENTICATOR_NAME = "TokenUIAuthenticator";
    private static Hashtable<String, HttpSession> sessionStore = new Hashtable();

    private boolean login(String username, String password, String remoteAddress) throws AuthenticationException {
        return new AuthenticationAdmin().login(username, password, remoteAddress);
    }

    public String getAutheticationToken(String username, String password, String remoteAddress) throws AuthenticationException {
        boolean isLoggedIn = false;
        isLoggedIn = this.login(username, password, remoteAddress);
        if (isLoggedIn) {
            String key = UUIDGenerator.getUUID();
            try {
                RegistryService registryService = TokenAuthBEDataHolder.getInstance().getRegistryService();
                RealmService realmService = TokenAuthBEDataHolder.getInstance().getRealmService();
                String tenantDomain = MultitenantUtils.getTenantDomain((String)username);
                int tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
                UserRealm realm = registryService.getUserRealm(tenantId);
                int userId = realm.getUserStoreManager().getUserId(username);
                String baseString = "TenantId:=" + tenantId + "&UserId:=" + userId;
                String signature = this.getHMAC(key, baseString);
                baseString = baseString + "&Signature:=" + signature;
                UserRegistry registry = registryService.getConfigSystemRegistry(tenantId);
                String path = "/users/" + username;
                Collection profile = null;
                if (!registry.resourceExists(path)) {
                    profile = registry.newCollection();
                    registry.put(path, (Resource)profile);
                } else {
                    profile = (Collection)registry.get(path);
                }
                Date date = new Date();
                int ttl = 300000;
                key = "Key:=" + key + "&Timestamp:=" + date.getTime() + "&TTL:=" + ttl;
                profile.removeProperty("user.token");
                profile.addProperty("user.token", key);
                registry.put(path, (Resource)profile);
                sessionStore.put(baseString, this.getHttpSession());
                return baseString;
            }
            catch (SignatureException e) {
                String msg = "Error in creating short lived authentication token for, username: " + username + ".";
                log.error((Object)msg, (Throwable)e);
                throw new AuthenticationException(msg, (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)("Error authenticating " + e.getMessage()), (Throwable)e);
                throw new AuthenticationException("Error authenticating " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private String getHMAC(String secretKey, String baseString) throws SignatureException {
        try {
            SecretKeySpec key = new SecretKeySpec(secretKey.getBytes(), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(key);
            byte[] rawHmac = mac.doFinal(baseString.getBytes());
            return Base64.encode((byte[])rawHmac);
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate HMAC : " + e.getMessage());
        }
    }

    public String getAuthenticatorName() {
        return AUTHENTICATOR_NAME;
    }

    public int getPriority() {
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(AUTHENTICATOR_NAME);
        if (authenticatorConfig != null && authenticatorConfig.getPriority() > 0) {
            return authenticatorConfig.getPriority();
        }
        return -5;
    }

    public boolean isAuthenticated(MessageContext messageContext) {
        String token = this.getAuthenticationTokenValue(messageContext);
        if (token != null) {
            HttpSession session = sessionStore.get(token);
            HttpSession newSession = this.getHttpSession(messageContext);
            newSession.setAttribute("WSO2RegistryRoot", session.getAttribute("WSO2RegistryRoot"));
            newSession.setAttribute("wso2carbon.admin.logged.in", session.getAttribute("wso2carbon.admin.logged.in"));
            SuperTenantCarbonContext newContext = SuperTenantCarbonContext.getCurrentContext((HttpSession)newSession);
            SuperTenantCarbonContext oldContext = SuperTenantCarbonContext.getCurrentContext((HttpSession)session);
            newContext.setRegistry(RegistryType.USER_GOVERNANCE, oldContext.getRegistry(RegistryType.USER_GOVERNANCE));
            newContext.setRegistry(RegistryType.USER_CONFIGURATION, oldContext.getRegistry(RegistryType.USER_CONFIGURATION));
            newContext.setRegistry(RegistryType.SYSTEM_CONFIGURATION, oldContext.getRegistry(RegistryType.SYSTEM_CONFIGURATION));
            newContext.setRegistry(RegistryType.SYSTEM_GOVERNANCE, oldContext.getRegistry(RegistryType.SYSTEM_GOVERNANCE));
            newContext.setUserRealm(oldContext.getUserRealm());
            newContext.setTenantDomain(oldContext.getTenantDomain());
            newContext.setTenantId(oldContext.getTenantId());
            String loginStatus = (String)session.getAttribute("wso2carbon.admin.logged.in");
            return loginStatus != null;
        }
        return false;
    }

    public boolean authenticateWithRememberMe(MessageContext messageContext) {
        return false;
    }

    protected HttpSession getHttpSession(MessageContext msgCtx) {
        HttpSession httpSession = null;
        if (msgCtx != null) {
            HttpServletRequest request = (HttpServletRequest)msgCtx.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            httpSession = request.getSession();
        }
        return httpSession;
    }

    private String getAuthenticationTokenValue(MessageContext messageContext) {
        Map headers = (Map)messageContext.getProperty("TRANSPORT_HEADERS");
        for (Map.Entry pairs : headers.entrySet()) {
            if (!"cookie".equals(pairs.getKey())) continue;
            return (String)pairs.getValue();
        }
        return null;
    }

    public boolean isDisabled() {
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(AUTHENTICATOR_NAME);
        if (authenticatorConfig != null) {
            return authenticatorConfig.isDisabled();
        }
        return false;
    }

    public boolean isHandle(MessageContext msgContext) {
        return true;
    }
}

