/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.token.ui;

import javax.servlet.http.HttpSession;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.common.AuthenticationException;
import org.wso2.carbon.identity.authenticator.token.stub.types.TokenBasedAuthenticatorStub;

public class TokenAuthenticatorClient {
    private TokenBasedAuthenticatorStub stub;
    private static final Log log = LogFactory.getLog(TokenAuthenticatorClient.class);

    public TokenAuthenticatorClient(ConfigurationContext ctx, String serverURL, String cookie, HttpSession session) throws Exception {
        String serviceEPR = serverURL + "TokenBasedAuthenticator";
        this.stub = new TokenBasedAuthenticatorStub(ctx, serviceEPR);
        ServiceClient client = this.stub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        if (cookie != null) {
            options.setProperty("Cookie", (Object)cookie);
        }
    }

    public String getAutheticationToken(String username, String password, String remoteAddress) throws Exception {
        return this.stub.getAutheticationToken(username, password, remoteAddress);
    }

    public void logout(HttpSession session) throws Exception {
        try {
            session.removeAttribute("wso2carbon.admin.service.cookie");
        }
        catch (Exception e) {
            String msg = "Error occurred while logging out";
            log.error((Object)msg, (Throwable)e);
            throw new AuthenticationException(msg, (Throwable)e);
        }
    }
}

