/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.token.ui;

import java.rmi.RemoteException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.common.AuthenticationException;
import org.wso2.carbon.core.security.AuthenticatorsConfiguration;
import org.wso2.carbon.identity.authenticator.token.ui.TokenAuthenticatorClient;
import org.wso2.carbon.ui.AbstractCarbonUIAuthenticator;
import org.wso2.carbon.ui.CarbonUIUtil;

public class TokenUIAuthenticator
extends AbstractCarbonUIAuthenticator {
    private static final Log log = LogFactory.getLog(TokenUIAuthenticator.class);
    private static final int DEFAULT_PRIORITY_LEVEL = -5;
    private static final String AUTHENTICATOR_NAME = "TokenUIAuthenticator";

    public boolean authenticate(Object object) throws AuthenticationException {
        HttpServletRequest request = (HttpServletRequest)object;
        String userName = request.getParameter("username");
        String password = request.getParameter("password");
        try {
            return this.authenticate(request, userName, password);
        }
        catch (RemoteException e) {
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isHandle(Object object) {
        return true;
    }

    public int getPriority() {
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(AUTHENTICATOR_NAME);
        if (authenticatorConfig != null && authenticatorConfig.getPriority() > 0) {
            return authenticatorConfig.getPriority();
        }
        return -5;
    }

    public String getAuthenticatorName() {
        return AUTHENTICATOR_NAME;
    }

    protected boolean authenticate(HttpServletRequest request, String userName, String password) throws RemoteException {
        try {
            ServletContext servletContext = request.getSession().getServletContext();
            ConfigurationContext configContext = (ConfigurationContext)servletContext.getAttribute("ConfigurationContext");
            if (configContext == null) {
                String msg = "Configuration context is null.";
                log.error((Object)msg);
                throw new RemoteException(msg);
            }
            HttpSession session = request.getSession();
            String backendServerURL = request.getParameter("backendURL");
            if (backendServerURL == null) {
                backendServerURL = CarbonUIUtil.getServerURL((ServletContext)servletContext, (HttpSession)request.getSession());
            }
            session.setAttribute("ServerURL", (Object)backendServerURL);
            String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
            TokenAuthenticatorClient proxy = new TokenAuthenticatorClient(configContext, backendServerURL, cookie, session);
            String userNameWithDomain = userName;
            String domainName = (String)request.getAttribute("tenantDomain");
            if (domainName != null) {
                userNameWithDomain = userNameWithDomain + "@" + domainName;
            }
            String token = proxy.getAutheticationToken(userNameWithDomain, password, request.getRemoteAddr());
            session.setAttribute("wso2carbon.admin.service.cookie", (Object)token);
            return token != null;
        }
        catch (AxisFault axisFault) {
            throw axisFault;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AxisFault("Exception occured", (Throwable)e);
        }
    }

    public void unauthenticate(Object object) throws Exception {
        HttpSession session = ((HttpServletRequest)object).getSession();
        ServletContext servletContext = session.getServletContext();
        ConfigurationContext configContext = (ConfigurationContext)servletContext.getAttribute("ConfigurationContext");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)servletContext, (HttpSession)session);
        try {
            String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
            TokenAuthenticatorClient proxy = new TokenAuthenticatorClient(configContext, backendServerURL, cookie, session);
            proxy.logout(session);
        }
        catch (Exception ignored) {
            String msg = "Configuration context is null.";
            log.error((Object)msg);
            throw new Exception(msg);
        }
    }

    public boolean isDisabled() {
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(AUTHENTICATOR_NAME);
        if (authenticatorConfig != null) {
            return authenticatorConfig.isDisabled();
        }
        return false;
    }

    public boolean reAuthenticateOnSessionExpire(Object object) throws AuthenticationException {
        return false;
    }
}

