/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.token.internal;

import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.core.services.authentication.CarbonServerAuthenticator;
import org.wso2.carbon.identity.authenticator.token.TokenAuthenticator;
import org.wso2.carbon.identity.authenticator.token.internal.TokenAuthBEDataHolder;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;

public class TokenAuthenticatorDSComponent {
    private static final Log log = LogFactory.getLog(TokenAuthenticatorDSComponent.class);

    protected void activate(ComponentContext ctxt) {
        try {
            TokenAuthenticator authenticator = new TokenAuthenticator();
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("authenticator.type", authenticator.getAuthenticatorName());
            ctxt.getBundleContext().registerService(CarbonServerAuthenticator.class.getName(), (Object)authenticator, props);
            log.debug((Object)"Carbon Core Services bundle is activated ");
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate Carbon Core Services bundle ", e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        log.debug((Object)"Carbon Core Services bundle is deactivated ");
    }

    protected void setRegistryService(RegistryService registryService) {
        TokenAuthBEDataHolder.getInstance().setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        TokenAuthBEDataHolder.getInstance().setRegistryService(null);
    }

    protected void setRealmService(RealmService realmService) {
        TokenAuthBEDataHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        TokenAuthBEDataHolder.getInstance().setRealmService(null);
    }
}

