/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.sso;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.CarbonConfigurationContextFactory;
import org.wso2.carbon.core.common.AuthenticationException;
import org.wso2.carbon.core.services.util.CarbonAuthenticationUtil;
import org.wso2.carbon.core.util.AnonymousSessionUtil;
import org.wso2.carbon.identity.authenticator.sso.SSOConsumer;
import org.wso2.carbon.identity.authenticator.sso.internal.SSOAuthBEDataHolder;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class SSOAuthenticator {
    private static final Log log = LogFactory.getLog(SSOAuthenticator.class);

    public boolean login(String username, String password, String remoteAddress) throws AuthenticationException {
        HttpSession httpSess = this.getHttpSession();
        try {
            if (username == null || password == null || remoteAddress == null || username.trim().equals("") || password.trim().equals("") || remoteAddress.trim().equals("")) {
                CarbonAuthenticationUtil.onFailedAdminLogin((HttpSession)httpSess, (String)username, (int)-1, (String)remoteAddress, (String)"Data");
                return false;
            }
            RegistryService registryService = SSOAuthBEDataHolder.getInstance().getRegistryService();
            RealmService realmService = SSOAuthBEDataHolder.getInstance().getRealmService();
            String tenantDomain = MultitenantUtils.getTenantDomain((String)username);
            username = MultitenantUtils.getTenantAwareUsername((String)username);
            UserRealm realm = AnonymousSessionUtil.getRealmByTenantDomain((RegistryService)registryService, (RealmService)realmService, (String)tenantDomain);
            boolean isAuthenticated = false;
            AxisConfiguration axisConfig = CarbonConfigurationContextFactory.getConfigurationContext().getAxisConfiguration();
            if (axisConfig.getParameter("ssoServiceEpr") != null) {
                String epr = (String)axisConfig.getParameter("ssoServiceEpr").getValue();
                isAuthenticated = new SSOConsumer(epr).isAuthenticated(username, password);
            }
            boolean isAuthorized = realm.getAuthorizationManager().isUserAuthorized(username, "/permission/admin/login", "ui.execute");
            int tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
            if (isAuthenticated && isAuthorized) {
                CarbonAuthenticationUtil.onSuccessAdminLogin((HttpSession)httpSess, (String)username, (int)tenantId, (String)tenantDomain, (String)remoteAddress);
                return true;
            }
            CarbonAuthenticationUtil.onFailedAdminLogin((HttpSession)httpSess, (String)username, (int)tenantId, (String)remoteAddress, (String)"Invalid credential");
            return false;
        }
        catch (Exception e) {
            String msg = "System error while Authenticating/Authorizing User : " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            return false;
        }
    }

    private HttpSession getHttpSession() {
        MessageContext msgCtx = MessageContext.getCurrentMessageContext();
        HttpSession httpSess = null;
        if (msgCtx != null) {
            HttpServletRequest request = (HttpServletRequest)msgCtx.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            httpSess = request.getSession();
        }
        return httpSess;
    }
}

