/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.sso;

import java.net.URL;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.util.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.authenticator.sso.stub.SSOServiceStub;

public class SSOConsumer {
    private SSOServiceStub service = null;
    private static final Log log = LogFactory.getLog(SSOConsumer.class);

    public SSOConsumer(String epr) throws AxisFault {
        this.service = new SSOServiceStub(epr);
        Options options = null;
        TransportOutDescription transportOut = null;
        options = this.service._getServiceClient().getOptions();
        transportOut = this.getTranport(epr);
        if (transportOut != null) {
            options.setTransportOut(transportOut);
        }
    }

    public String autneticate(String userName, String password) {
        try {
            return this.service.authenticate(userName, password);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SSO enabled authentication failed.", (Throwable)e);
            }
            return null;
        }
    }

    public boolean isAuthenticated(String userName, String sessionId) {
        try {
            return this.service.isAuthenticated(userName, sessionId);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SSO enabled authentication failed.", (Throwable)e);
            }
            return false;
        }
    }

    public void signout(String userName, String sessionId) {
        block2: {
            try {
                this.service.signOut(userName, sessionId);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"SSO enabled sign out failed.", (Throwable)e);
            }
        }
    }

    private TransportOutDescription getTranport(String epr) {
        TransportOutDescription transport = null;
        try {
            URL url = new URL(epr);
            String protocol = url.getProtocol();
            if ("http".equalsIgnoreCase(protocol) || "https".equalsIgnoreCase(protocol)) {
                transport = new TransportOutDescription(protocol);
                Class senderClass = Loader.loadClass((String)"org.apache.axis2.transport.http.CommonsHTTPTransportSender");
                TransportSender sender = (TransportSender)senderClass.newInstance();
                transport.setSender(sender);
                transport.addParameter(new Parameter("PROTOCOL", (Object)"HTTP/1.1"));
                transport.addParameter(new Parameter("Transfer-Encoding", (Object)"chunked"));
                transport.addParameter(new Parameter("OmitSOAP12Action", (Object)"true"));
            }
        }
        catch (Exception e) {
            return null;
        }
        return transport;
    }
}

