/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.saml2.sso;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Response;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.signature.SignatureValidator;
import org.opensaml.xml.validation.ValidationException;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.core.security.AuthenticatorsConfiguration;
import org.wso2.carbon.core.services.authentication.CarbonServerAuthenticator;
import org.wso2.carbon.core.services.util.CarbonAuthenticationUtil;
import org.wso2.carbon.core.util.AnonymousSessionUtil;
import org.wso2.carbon.core.util.PermissionUpdateUtil;
import org.wso2.carbon.identity.authenticator.saml2.sso.SAML2SSOAuthenticatorException;
import org.wso2.carbon.identity.authenticator.saml2.sso.dto.AuthnReqDTO;
import org.wso2.carbon.identity.authenticator.saml2.sso.internal.SAML2SSOAuthBEDataHolder;
import org.wso2.carbon.identity.authenticator.saml2.sso.util.Util;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.AuthenticationObserver;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class SAML2SSOAuthenticator
implements CarbonServerAuthenticator {
    private static final int DEFAULT_PRIORITY_LEVEL = 3;
    private static final String AUTHENTICATOR_NAME = "SAML2SSOAuthenticator";
    public static final Log log = LogFactory.getLog(SAML2SSOAuthenticator.class);

    public boolean login(AuthnReqDTO authDto) {
        HttpSession httpSession = this.getHttpSession();
        try {
            Response response = (Response)Util.unmarshall(authDto.getResponse());
            String username = this.getUsernameFromResponse(response);
            if (username == null || username.trim().equals("")) {
                log.error((Object)"Authentication Request is rejected. SAMLResponse does not contain the username of the subject.");
                CarbonAuthenticationUtil.onFailedAdminLogin((HttpSession)httpSession, (String)username, (int)-1, (String)"SAML2 SSO Authentication", (String)"Data");
                return false;
            }
            RegistryService registryService = SAML2SSOAuthBEDataHolder.getInstance().getRegistryService();
            RealmService realmService = SAML2SSOAuthBEDataHolder.getInstance().getRealmService();
            String tenantDomain = MultitenantUtils.getTenantDomain((String)username);
            int tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
            this.handleAuthenticationStarted(tenantId);
            boolean isSignatureValid = this.validateSignature(response, tenantDomain);
            if (!isSignatureValid) {
                log.error((Object)"Authentication Request is rejected.  Signature validation failed.");
                CarbonAuthenticationUtil.onFailedAdminLogin((HttpSession)httpSession, (String)username, (int)tenantId, (String)"SAML2 SSO Authentication", (String)"Invalid Signature");
                this.handleAuthenticationCompleted(tenantId, false);
                return false;
            }
            username = MultitenantUtils.getTenantAwareUsername((String)username);
            UserRealm realm = AnonymousSessionUtil.getRealmByTenantDomain((RegistryService)registryService, (RealmService)realmService, (String)tenantDomain);
            PermissionUpdateUtil.updatePermissionTree((int)tenantId);
            boolean isAuthorized = realm.getAuthorizationManager().isUserAuthorized(username, "/permission/admin/login", "ui.execute");
            if (isAuthorized) {
                CarbonAuthenticationUtil.onSuccessAdminLogin((HttpSession)httpSession, (String)username, (int)tenantId, (String)tenantDomain, (String)"SAML2 SSO Authentication");
                this.handleAuthenticationCompleted(tenantId, true);
                return true;
            }
            log.error((Object)"Authentication Request is rejected. Authorization Failure.");
            CarbonAuthenticationUtil.onFailedAdminLogin((HttpSession)httpSession, (String)username, (int)tenantId, (String)"SAML2 SSO Authentication", (String)"Invalid credential");
            this.handleAuthenticationCompleted(tenantId, false);
            return false;
        }
        catch (Exception e) {
            String msg = "System error while Authenticating/Authorizing User : " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            return false;
        }
    }

    private void handleAuthenticationStarted(int tenantId) {
        BundleContext bundleContext = SAML2SSOAuthBEDataHolder.getInstance().getBundleContext();
        if (bundleContext != null) {
            ServiceTracker tracker = new ServiceTracker(bundleContext, AuthenticationObserver.class.getName(), null);
            tracker.open();
            Object[] services = tracker.getServices();
            if (services != null) {
                for (Object service : services) {
                    ((AuthenticationObserver)service).startedAuthentication(tenantId);
                }
            }
            tracker.close();
        }
    }

    private void handleAuthenticationCompleted(int tenantId, boolean isSuccessful) {
        BundleContext bundleContext = SAML2SSOAuthBEDataHolder.getInstance().getBundleContext();
        if (bundleContext != null) {
            ServiceTracker tracker = new ServiceTracker(bundleContext, AuthenticationObserver.class.getName(), null);
            tracker.open();
            Object[] services = tracker.getServices();
            if (services != null) {
                for (Object service : services) {
                    ((AuthenticationObserver)service).completedAuthentication(tenantId, isSuccessful);
                }
            }
            tracker.close();
        }
    }

    public void logout() {
        Date currentTime = Calendar.getInstance().getTime();
        SimpleDateFormat date = new SimpleDateFormat("'['yyyy-MM-dd HH:mm:ss,SSSS']'");
        HttpSession session = this.getHttpSession();
        if (session != null) {
            String loggedInUser = (String)session.getAttribute("wso2carbon.admin.logged.in");
            String delegatedBy = (String)session.getAttribute("DELEGATED_BY");
            if (delegatedBy == null) {
                log.info((Object)("'" + loggedInUser + "' logged out at " + date.format(currentTime)));
            } else {
                log.info((Object)("'" + loggedInUser + "' logged out at " + date.format(currentTime) + " delegated by " + delegatedBy));
            }
            session.invalidate();
        }
    }

    public boolean isHandle(MessageContext messageContext) {
        return true;
    }

    public boolean isAuthenticated(MessageContext messageContext) {
        HttpServletRequest request = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = request.getSession();
        String loginStatus = (String)httpSession.getAttribute("wso2carbon.admin.logged.in");
        return loginStatus != null;
    }

    public boolean authenticateWithRememberMe(MessageContext messageContext) {
        return false;
    }

    public int getPriority() {
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(AUTHENTICATOR_NAME);
        if (authenticatorConfig != null && authenticatorConfig.getPriority() > 0) {
            return authenticatorConfig.getPriority();
        }
        return 3;
    }

    public String getAuthenticatorName() {
        return AUTHENTICATOR_NAME;
    }

    public boolean isDisabled() {
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(AUTHENTICATOR_NAME);
        if (authenticatorConfig != null) {
            return authenticatorConfig.isDisabled();
        }
        return false;
    }

    private boolean validateSignature(Response response, String domainName) {
        boolean isSignatureValid = false;
        if (response.getSignature() == null) {
            log.error((Object)"SAML Response is not signed. So authentication process will be terminated.");
        } else {
            try {
                SignatureValidator validator = new SignatureValidator((Credential)Util.getX509CredentialImplForTenant(domainName));
                validator.validate(response.getSignature());
                isSignatureValid = true;
            }
            catch (SAML2SSOAuthenticatorException e) {
                String errorMsg = "Error when creating an X509CredentialImpl instance";
                log.error((Object)errorMsg, (Throwable)e);
            }
            catch (ValidationException e) {
                log.warn((Object)("Signature validation failed for a SAML2 Reposnse from domain : " + domainName));
            }
        }
        return isSignatureValid;
    }

    private String getUsernameFromResponse(Response response) {
        List assertions = response.getAssertions();
        Assertion assertion = null;
        if (assertions != null && assertions.size() > 0) {
            assertion = (Assertion)assertions.get(0);
            return assertion.getSubject().getNameID().getValue();
        }
        return null;
    }

    private HttpSession getHttpSession() {
        MessageContext msgCtx = MessageContext.getCurrentMessageContext();
        HttpSession httpSession = null;
        if (msgCtx != null) {
            HttpServletRequest request = (HttpServletRequest)msgCtx.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            httpSession = request.getSession();
        }
        return httpSession;
    }
}

