/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding;

import javax.xml.namespace.QName;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.ws.message.BaseMessageContext;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.util.DatatypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicSAMLMessageContext<InboundMessageType extends SAMLObject, OutboundMessageType extends SAMLObject, NameIdentifierType extends SAMLObject>
extends BaseMessageContext
implements SAMLMessageContext<InboundMessageType, OutboundMessageType, NameIdentifierType> {
    private byte[] artifactType;
    private NameIdentifierType subjectNameIdentifer;
    private String localEntityId;
    private EntityDescriptor localEntityMetadata;
    private QName localEntityRole;
    private RoleDescriptor localEntityRoleMetadata;
    private InboundMessageType inboundSAMLMessage;
    private boolean inboundSAMLMessageAuthenticated;
    private String inboundSAMLMessageId;
    private DateTime inboundSAMLMessageIssueInstant;
    private String inboundSAMLProtocol;
    private MetadataProvider metdataProvider;
    private OutboundMessageType outboundSAMLMessage;
    private String outboundSAMLMessageId;
    private DateTime outboundSAMLMessageIssueInstant;
    private Credential outboundSAMLMessageSigningCredential;
    private String outboundSAMLProtocol;
    private String relayState;
    private Endpoint peerEntityEndpoint;
    private String peerEntityId;
    private EntityDescriptor peerEntityMetadata;
    private QName peerEntityRole;
    private RoleDescriptor peerEntityRoleMetadata;

    @Override
    public InboundMessageType getInboundSAMLMessage() {
        return this.inboundSAMLMessage;
    }

    @Override
    public String getInboundSAMLMessageId() {
        return this.inboundSAMLMessageId;
    }

    @Override
    public DateTime getInboundSAMLMessageIssueInstant() {
        return this.inboundSAMLMessageIssueInstant;
    }

    @Override
    public String getInboundSAMLProtocol() {
        return this.inboundSAMLProtocol;
    }

    @Override
    public String getLocalEntityId() {
        return this.localEntityId;
    }

    @Override
    public EntityDescriptor getLocalEntityMetadata() {
        return this.localEntityMetadata;
    }

    @Override
    public QName getLocalEntityRole() {
        return this.localEntityRole;
    }

    @Override
    public RoleDescriptor getLocalEntityRoleMetadata() {
        return this.localEntityRoleMetadata;
    }

    @Override
    public MetadataProvider getMetadataProvider() {
        return this.metdataProvider;
    }

    @Override
    public Credential getOuboundSAMLMessageSigningCredential() {
        return this.outboundSAMLMessageSigningCredential;
    }

    @Override
    public OutboundMessageType getOutboundSAMLMessage() {
        return this.outboundSAMLMessage;
    }

    @Override
    public String getOutboundSAMLMessageId() {
        return this.outboundSAMLMessageId;
    }

    @Override
    public DateTime getOutboundSAMLMessageIssueInstant() {
        return this.outboundSAMLMessageIssueInstant;
    }

    @Override
    public String getOutboundSAMLProtocol() {
        return this.outboundSAMLProtocol;
    }

    @Override
    public Endpoint getPeerEntityEndpoint() {
        return this.peerEntityEndpoint;
    }

    @Override
    public String getPeerEntityId() {
        return this.peerEntityId;
    }

    @Override
    public EntityDescriptor getPeerEntityMetadata() {
        return this.peerEntityMetadata;
    }

    @Override
    public QName getPeerEntityRole() {
        return this.peerEntityRole;
    }

    @Override
    public RoleDescriptor getPeerEntityRoleMetadata() {
        return this.peerEntityRoleMetadata;
    }

    @Override
    public String getRelayState() {
        return this.relayState;
    }

    @Override
    public NameIdentifierType getSubjectNameIdentifier() {
        return this.subjectNameIdentifer;
    }

    @Override
    public boolean isInboundSAMLMessageAuthenticated() {
        return this.inboundSAMLMessageAuthenticated;
    }

    @Override
    public void setInboundSAMLMessage(InboundMessageType message) {
        this.inboundSAMLMessage = message;
    }

    @Override
    public void setInboundSAMLMessageAuthenticated(boolean isAuthenticated) {
        this.inboundSAMLMessageAuthenticated = isAuthenticated;
    }

    @Override
    public void setInboundSAMLMessageId(String id) {
        this.inboundSAMLMessageId = DatatypeHelper.safeTrimOrNullString(id);
    }

    @Override
    public void setInboundSAMLMessageIssueInstant(DateTime instant) {
        this.inboundSAMLMessageIssueInstant = instant;
    }

    @Override
    public void setInboundSAMLProtocol(String protocol) {
        this.inboundSAMLProtocol = DatatypeHelper.safeTrimOrNullString(protocol);
    }

    @Override
    public void setLocalEntityId(String id) {
        this.localEntityId = DatatypeHelper.safeTrimOrNullString(id);
    }

    @Override
    public void setLocalEntityMetadata(EntityDescriptor metadata) {
        this.localEntityMetadata = metadata;
    }

    @Override
    public void setLocalEntityRole(QName role) {
        this.localEntityRole = role;
    }

    @Override
    public void setLocalEntityRoleMetadata(RoleDescriptor role) {
        this.localEntityRoleMetadata = role;
    }

    @Override
    public void setMetadataProvider(MetadataProvider provider) {
        this.metdataProvider = provider;
    }

    @Override
    public void setOutboundSAMLMessage(OutboundMessageType message) {
        this.outboundSAMLMessage = message;
    }

    @Override
    public void setOutboundSAMLMessageId(String id) {
        this.outboundSAMLMessageId = DatatypeHelper.safeTrimOrNullString(id);
    }

    @Override
    public void setOutboundSAMLMessageIssueInstant(DateTime instant) {
        this.outboundSAMLMessageIssueInstant = instant;
    }

    @Override
    public void setOutboundSAMLMessageSigningCredential(Credential credential) {
        this.outboundSAMLMessageSigningCredential = credential;
    }

    @Override
    public void setOutboundSAMLProtocol(String protocol) {
        this.outboundSAMLProtocol = DatatypeHelper.safeTrimOrNullString(protocol);
    }

    @Override
    public void setPeerEntityEndpoint(Endpoint endpoint) {
        this.peerEntityEndpoint = endpoint;
    }

    @Override
    public void setPeerEntityId(String id) {
        this.peerEntityId = DatatypeHelper.safeTrimOrNullString(id);
    }

    @Override
    public void setPeerEntityMetadata(EntityDescriptor metadata) {
        this.peerEntityMetadata = metadata;
    }

    @Override
    public void setPeerEntityRole(QName role) {
        this.peerEntityRole = role;
    }

    @Override
    public void setPeerEntityRoleMetadata(RoleDescriptor role) {
        this.peerEntityRoleMetadata = role;
    }

    @Override
    public void setRelayState(String state) {
        this.relayState = DatatypeHelper.safeTrimOrNullString(state);
    }

    @Override
    public void setSubjectNameIdentifier(NameIdentifierType identifier) {
        this.subjectNameIdentifer = identifier;
    }

    @Override
    public byte[] getOutboundMessageArtifactType() {
        return this.artifactType;
    }

    @Override
    public void setOutboundMessageArtifactType(byte[] type) {
        this.artifactType = type;
    }

    @Override
    public boolean isIssuerAuthenticated() {
        return this.isInboundSAMLMessageAuthenticated() || super.isIssuerAuthenticated();
    }
}

