/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.ui.fileupload;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.humantask.ui.fileupload.ArchiveExtractor;
import org.wso2.carbon.humantask.ui.fileupload.HIUploaderClient;
import org.wso2.carbon.ui.CarbonUIMessage;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.utils.FileItemData;

public class HumanTaskUploadExecutor
extends AbstractFileUploadExecutor {
    private static Log log = LogFactory.getLog(HumanTaskUploadExecutor.class);
    private static final String[] ALLOWED_FILE_EXTENSIONS = new String[]{".zip"};

    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws CarbonException, IOException {
        response.setContentType("text/html; charset=utf-8");
        PrintWriter out = response.getWriter();
        String webContext = (String)request.getAttribute("WebContext");
        String serverURL = (String)request.getAttribute("ServerURL");
        String cookie = (String)request.getAttribute("wso2carbon.admin.service.cookie");
        Map fileItemsMap = this.getFileItemsMap();
        if (fileItemsMap == null || fileItemsMap.isEmpty()) {
            String msg = "File uploading failed.";
            log.error((Object)msg);
            out.write("<textarea>(function(){i18n.fileUplodedFailed();})();</textarea>");
            return true;
        }
        HIUploaderClient uploaderClient = new HIUploaderClient(this.configurationContext, serverURL + "HumanTaskUploader", cookie);
        try {
            for (FileItemData fieldData : (ArrayList)fileItemsMap.get("humantaskFileName")) {
                String fileName = this.getFileName(fieldData.getFileItem().getName());
                if (fileName.matches("(.*[\\\\].*[/].*|.*[/].*[\\\\].*)")) {
                    log.error((Object)"HumanTask Package Validation Failure: one or many of the following illegal characters are in the package.\n ~!@#$;%^*()+={}[]| \\<>");
                    throw new Exception("HumanTask Package Validation Failure: one or many of the following illegal characters are in the package. ~!@#$;%^*()+={}[]| \\<>");
                }
                this.checkServiceFileExtensionValidity(fileName, ALLOWED_FILE_EXTENSIONS);
                if (fileName.lastIndexOf(92) != -1) {
                    int indexOfColon = fileName.lastIndexOf(92) + 1;
                    fileName = fileName.substring(indexOfColon, fileName.length());
                }
                if (!"humantaskFileName".equals(fieldData.getFileItem().getFieldName())) continue;
                SaveExtractReturn uploadedFiles = this.saveAndExtractUploadedFile(fieldData.getFileItem());
                this.validateHumanTaskPackage(uploadedFiles.extractedFile);
                FileDataSource dataSource = new FileDataSource(uploadedFiles.zipFile);
                uploaderClient.addUploadedFileItem(new DataHandler((DataSource)dataSource), fileName, "zip");
            }
            uploaderClient.uploadFileItems();
            String msg = "Your HumanTask package been uploaded successfully. Please refresh this page in a while to see the status of the new package.";
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"info", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/humantask/humantask_definition_list.jsp"));
            return true;
        }
        catch (Exception e) {
            String errMsg = "File upload failed :" + e.getMessage();
            log.error((Object)errMsg, (Throwable)e);
            CarbonUIMessage.sendCarbonUIMessage((String)errMsg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/humantask/upload_humantask.jsp"));
            return false;
        }
    }

    public SaveExtractReturn saveAndExtractUploadedFile(FileItem fileItem) throws Exception {
        String serviceUploadDir = this.getTempUploadDir();
        File servicesDir = new File(serviceUploadDir);
        if (!servicesDir.exists() && !servicesDir.mkdirs()) {
            throw new IOException("Fail to create the directory: " + servicesDir.getAbsolutePath());
        }
        String fileItemName = this.getFileName(fileItem.getName());
        File uploadedFile = new File(servicesDir, fileItemName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("[HumanTaskUI]HumanTask Archive Path: " + uploadedFile.getAbsolutePath()));
        }
        try {
            fileItem.write(uploadedFile);
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while writing file item to file system.", (Throwable)e);
            throw new Exception("Error occurred while writing file item to file system.", e);
        }
        String destinationDir = serviceUploadDir + fileItemName.substring(0, fileItemName.lastIndexOf(46));
        if (log.isDebugEnabled()) {
            log.debug((Object)("[HumanTaskUI]HumanTask package location: " + destinationDir));
        }
        try {
            ArchiveExtractor.extract(uploadedFile, destinationDir);
        }
        catch (Exception e) {
            log.error((Object)"Error extracting archive.", (Throwable)e);
            throw new Exception(e);
        }
        return new SaveExtractReturn(uploadedFile.getAbsolutePath(), destinationDir);
    }

    private String getTempUploadDir() {
        String uuid = this.generateUUID();
        String tmpDir = "humantaskTemp";
        return this.getWorkingDir() + File.separator + tmpDir + File.separator + uuid + File.separator;
    }

    public void validateHumanTaskPackage(String directoryPath) throws Exception {
        String htConfigFilePathString = directoryPath + File.separator + "htconfig.xml";
        File htConfigFile = new File(htConfigFilePathString);
        if (!htConfigFile.exists()) {
            throw new Exception("The uploaded task definition zip file does not contain a htconfig.xmlfile. Please check the package and re-upload.");
        }
    }

    static class SaveExtractReturn {
        private String zipFile;
        private String extractedFile;

        public SaveExtractReturn(String zipFile, String extractedFile) {
            this.zipFile = zipFile;
            this.extractedFile = extractedFile;
        }
    }
}

