/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.ui.clients;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import javax.activation.DataHandler;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.humantask.stub.mgt.HumanTaskPackageManagementStub;
import org.wso2.carbon.humantask.stub.mgt.PackageManagementException;
import org.wso2.carbon.humantask.stub.mgt.types.DeployedTaskDefinitionsPaginated;
import org.wso2.carbon.humantask.stub.mgt.types.HumanTaskPackageDownloadData;
import org.wso2.carbon.humantask.stub.mgt.types.TaskInfoType;
import org.wso2.carbon.humantask.stub.mgt.types.Task_type0;
import org.wso2.carbon.humantask.stub.mgt.types.UndeployStatus_type0;

public class HumanTaskPackageManagementServiceClient {
    private static Log log = LogFactory.getLog(HumanTaskPackageManagementServiceClient.class);
    private HumanTaskPackageManagementStub stub;

    public HumanTaskPackageManagementServiceClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws AxisFault {
        String serviceURL = backendServerURL + "HumanTaskPackageManagement";
        this.stub = new HumanTaskPackageManagementStub(configContext, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
    }

    public DeployedTaskDefinitionsPaginated getPaginatedTaskDefinitions(int page) throws RemoteException, PackageManagementException {
        try {
            return this.stub.listDeployedTaskDefinitionsPaginated(page);
        }
        catch (RemoteException e) {
            log.error((Object)"listDeployedTaskDefinitionsPaginated operation invocation failed.", (Throwable)e);
            throw e;
        }
        catch (PackageManagementException e) {
            log.error((Object)"listDeployedTaskDefinitionsPaginated operation failed.", (Throwable)e);
            throw e;
        }
    }

    public UndeployStatus_type0 unDeployPackage(String packageName) throws RemoteException, PackageManagementException {
        try {
            return this.stub.undeployHumanTaskPackage(packageName);
        }
        catch (RemoteException e) {
            log.error((Object)"listDeployedPackagesPaginated operation invocation failed.", (Throwable)e);
            throw e;
        }
        catch (PackageManagementException e) {
            log.error((Object)"listDeployedPackagesPaginated operation failed.", (Throwable)e);
            throw e;
        }
    }

    public Task_type0[] listTasksInPackage(String packageName) throws RemoteException, PackageManagementException {
        try {
            return this.stub.listTasksInPackage(packageName);
        }
        catch (RemoteException e) {
            log.error((Object)"listDeployedPackagesPaginated operation invocation failed.", (Throwable)e);
            throw e;
        }
        catch (PackageManagementException e) {
            log.error((Object)"listDeployedPackagesPaginated operation failed.", (Throwable)e);
            throw e;
        }
    }

    public TaskInfoType getTaskInfo(QName taskId) throws PackageManagementException, RemoteException {
        return this.stub.getTaskInfo(taskId);
    }

    public void downloadHumanTaskPackage(String humanTaskPackageName, HttpServletResponse response) throws PackageManagementException, IOException {
        try {
            ServletOutputStream out = response.getOutputStream();
            HumanTaskPackageDownloadData downloadData = this.stub.downloadHumanTaskPackage(humanTaskPackageName);
            if (downloadData != null) {
                int nextChar;
                DataHandler handler = downloadData.getPackageFileData();
                response.setHeader("Content-Disposition", "fileName=" + downloadData.getPackageName());
                response.setContentType(handler.getContentType());
                InputStream in = handler.getDataSource().getInputStream();
                while ((nextChar = in.read()) != -1) {
                    out.write((int)((char)nextChar));
                }
                out.flush();
                in.close();
            } else {
                out.write("The requested package archive was not found on the server".getBytes());
            }
        }
        catch (RemoteException e) {
            log.error((Object)e);
            throw e;
        }
        catch (IOException e) {
            log.error((Object)e);
            throw e;
        }
    }
}

