/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.ui.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.wso2.carbon.humantask.stub.mgt.types.TaskInfoType;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TAttachmentInfo;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TComment;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TPresentationName;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TPresentationSubject;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TTaskAbstract;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TTaskAuthorisationParams;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TTaskEvent;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TTaskEvents;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TUser;
import org.wso2.carbon.utils.xml.XMLPrettyPrinter;

public final class HumanTaskUIUtil {
    private static Log log = LogFactory.getLog(HumanTaskUIUtil.class);

    private HumanTaskUIUtil() {
    }

    public static String getUnDeployLink(String packageName) {
        return "humantask_definition_list.jsp?operation=unDeploy&packageName=" + packageName;
    }

    public static void logError(Object error, Throwable ex) {
        log.error(error, ex);
    }

    public static String getCookieSessionId(String cookie) {
        if (cookie != null && cookie.contains("JSESSIONID=")) {
            int startIndex = cookie.lastIndexOf("JSESSIONID=");
            int lastIndex = startIndex + 43;
            return cookie.substring(startIndex, lastIndex);
        }
        return null;
    }

    public static String getTaskPresentationHeader(TPresentationSubject pSub, TPresentationName pName) {
        String presentationName = "";
        if (pSub != null && pSub.getTPresentationSubject() != null) {
            presentationName = pSub.getTPresentationSubject();
        } else if (pName != null && pName.getTPresentationName() != null) {
            presentationName = pName.getTPresentationName();
        }
        return presentationName;
    }

    public static String getTaskDisplayId(TTaskAbstract task) {
        return task.getName().getLocalPart() + "-" + task.getId().toString();
    }

    public static String loadTaskDetailsJSONString(TTaskAbstract task) {
        JSONObject taskDetailsJSONObject = new JSONObject();
        if (task != null) {
            if (task.getPresentationSubject() != null) {
                taskDetailsJSONObject.put((Object)"taskPresentationSubject", (Object)task.getPresentationSubject().toString());
            }
            if (task.getStatus() != null) {
                taskDetailsJSONObject.put((Object)"taskStatus", (Object)task.getStatus().toString().trim());
            }
            if (task.getPreviousStatus() != null && !"".equals(task.getPreviousStatus().toString().trim())) {
                taskDetailsJSONObject.put((Object)"taskPreviousStatus", (Object)task.getPreviousStatus().toString().trim());
            }
            taskDetailsJSONObject.put((Object)"taskPriority", (Object)task.getPriority().toString());
            taskDetailsJSONObject.put((Object)"taskCreatedOn", (Object)task.getCreatedTime().getTime().toString());
            taskDetailsJSONObject.put((Object)"taskCreatedBy", (Object)"");
            if (task.getUpdatedTime() != null) {
                taskDetailsJSONObject.put((Object)"taskUpdatedOn", (Object)task.getUpdatedTime().getTime().toString());
            }
            taskDetailsJSONObject.put((Object)"taskUpdatedBy", (Object)"");
            if (task.getPresentationName() != null) {
                taskDetailsJSONObject.put((Object)"taskPresentationName", (Object)task.getPresentationName().toString());
            }
            if (task.getActualOwner() != null) {
                taskDetailsJSONObject.put((Object)"taskOwner", (Object)task.getActualOwner().toString());
            }
            taskDetailsJSONObject.put((Object)"taskType", (Object)task.getTaskType());
            if (task.getPresentationDescription() != null) {
                taskDetailsJSONObject.put((Object)"taskPresentationDescription", (Object)task.getPresentationDescription().toString());
            }
        }
        return taskDetailsJSONObject.toJSONString();
    }

    public static String loadTaskAuthParamsJSONString(TTaskAuthorisationParams authParams) {
        JSONObject taskAuthParamsJSON = new JSONObject();
        if (authParams != null) {
            taskAuthParamsJSON.put((Object)"authorisedToActivate", (Object)authParams.getAuthorisedToActivate());
            taskAuthParamsJSON.put((Object)"authorisedToClaim", (Object)authParams.getAuthorisedToClaim());
            taskAuthParamsJSON.put((Object)"authorisedToComment", (Object)authParams.getAuthorisedToComment());
            taskAuthParamsJSON.put((Object)"authorisedToComplete", (Object)authParams.getAuthorisedToComplete());
            taskAuthParamsJSON.put((Object)"authorisedToDelegate", (Object)authParams.getAuthorisedToDelegate());
            taskAuthParamsJSON.put((Object)"authorisedToDeleteFault", (Object)authParams.getAuthorisedToDeleteFault());
            taskAuthParamsJSON.put((Object)"authorisedToDeleteComment", (Object)authParams.getAuthorisedToDeleteComment());
            taskAuthParamsJSON.put((Object)"authorisedToDeleteOutput", (Object)authParams.getAuthorisedToDeleteOutput());
            taskAuthParamsJSON.put((Object)"authorisedToExit", (Object)authParams.getAuthorisedToExit());
            taskAuthParamsJSON.put((Object)"authorisedToFail", (Object)authParams.getAuthorisedToFail());
            taskAuthParamsJSON.put((Object)"authorisedToForward", (Object)authParams.getAuthorisedToForward());
            taskAuthParamsJSON.put((Object)"authorisedToGetComments", (Object)authParams.getAuthorisedToGetComments());
            taskAuthParamsJSON.put((Object)"authorisedToGetDescription", (Object)authParams.getAuthorisedToGetDescription());
            taskAuthParamsJSON.put((Object)"authorisedToGetInput", (Object)authParams.getAuthorisedToGetInput());
            taskAuthParamsJSON.put((Object)"authorisedToNominate", (Object)authParams.getAuthorisedToNominate());
            taskAuthParamsJSON.put((Object)"authorisedToRelease", (Object)authParams.getAuthorisedToRelease());
            taskAuthParamsJSON.put((Object)"authorisedToResume", (Object)authParams.getAuthorisedToResume());
            taskAuthParamsJSON.put((Object)"authorisedToRemove", (Object)authParams.getAuthorisedToRemove());
            taskAuthParamsJSON.put((Object)"authorisedToSetFault", (Object)authParams.getAuthorisedToSetFault());
            taskAuthParamsJSON.put((Object)"authorisedToSetOutput", (Object)authParams.getAuthorisedToSetOutput());
            taskAuthParamsJSON.put((Object)"authorisedToSetPriority", (Object)authParams.getAuthorisedToSetPriority());
            taskAuthParamsJSON.put((Object)"authorisedToSkip", (Object)authParams.getAuthorisedToSkip());
            taskAuthParamsJSON.put((Object)"authorisedToStart", (Object)authParams.getAuthorisedToStart());
            taskAuthParamsJSON.put((Object)"authorisedToStop", (Object)authParams.getAuthorisedToStop());
            taskAuthParamsJSON.put((Object)"authorisedToSuspend", (Object)authParams.getAuthorisedToSuspend());
            taskAuthParamsJSON.put((Object)"authorisedToUpdateComment", (Object)authParams.getAuthorisedToUpdateComment());
        }
        return taskAuthParamsJSON.toJSONString();
    }

    public static String loadTaskCommentsJSONString(TComment[] comments) {
        LinkedHashMap<String, JSONObject> commentsMap = new LinkedHashMap<String, JSONObject>();
        if (comments != null) {
            for (TComment comment : comments) {
                JSONObject commentObject = new JSONObject();
                commentObject.put((Object)"commentId", (Object)comment.getId().toString());
                commentObject.put((Object)"commentText", (Object)comment.getText());
                if (comment.getAddedBy() != null) {
                    commentObject.put((Object)"commentAddedBy", (Object)comment.getAddedBy().getTUser());
                }
                if (comment.getAddedTime() != null) {
                    commentObject.put((Object)"commentAddedTime", (Object)comment.getAddedTime().getTime().toString());
                }
                if (comment.getLastModifiedBy() != null) {
                    commentObject.put((Object)"commentLastModifiedBy", (Object)comment.getLastModifiedBy().getTUser());
                }
                if (comment.getLastModifiedTime() != null) {
                    commentObject.put((Object)"commentLastModifiedTime", (Object)comment.getLastModifiedTime().getTime().toString());
                }
                commentsMap.put(comment.getId().toString(), commentObject);
            }
        }
        return JSONObject.toJSONString(commentsMap);
    }

    public static String loadTaskAttachmentsJSONString(TAttachmentInfo[] attachmentInfos) {
        LinkedHashMap<String, JSONObject> taskAttachmentsMap = new LinkedHashMap<String, JSONObject>();
        if (attachmentInfos != null && attachmentInfos.length > 0) {
            for (TAttachmentInfo attachment : attachmentInfos) {
                JSONObject attachmentJSON = new JSONObject();
                attachmentJSON.put((Object)"attachmentName", (Object)attachment.getName());
                attachmentJSON.put((Object)"attachmentContentType", (Object)attachment.getContentType());
                attachmentJSON.put((Object)"attachmentLink", (Object)attachment.getIdentifier().toString());
                taskAttachmentsMap.put(attachment.getIdentifier().toString(), attachmentJSON);
            }
        }
        return JSONObject.toJSONString(taskAttachmentsMap);
    }

    public static String loadTaskEventsJSONString(TTaskEvents taskEvents) {
        LinkedHashMap<String, JSONObject> taskEventsMap = new LinkedHashMap<String, JSONObject>();
        if (taskEvents != null && taskEvents.getEvent() != null) {
            for (TTaskEvent taskEvent : taskEvents.getEvent()) {
                JSONObject eventJSON = new JSONObject();
                eventJSON.put((Object)"eventId", (Object)taskEvent.getEventId().toString());
                if (taskEvent.getEventDetail() != null) {
                    eventJSON.put((Object)"eventDetail", (Object)taskEvent.getEventDetail());
                }
                if (taskEvent.getOldState() != null) {
                    eventJSON.put((Object)"oldState", (Object)taskEvent.getOldState().toString());
                }
                if (taskEvent.getNewState() != null) {
                    eventJSON.put((Object)"newState", (Object)taskEvent.getNewState().toString());
                }
                eventJSON.put((Object)"eventInitiator", (Object)taskEvent.getEventInitiator().getTUser());
                eventJSON.put((Object)"eventType", (Object)taskEvent.getEventType());
                if (taskEvent.getEventTime() != null) {
                    eventJSON.put((Object)"eventTime", (Object)taskEvent.getEventTime().getTime().toString());
                }
                taskEventsMap.put(taskEvent.getEventId().toString(), eventJSON);
            }
        }
        return JSONObject.toJSONString(taskEventsMap);
    }

    public static String loadUserJSONString(TUser[] users) {
        LinkedHashMap<String, JSONObject> userMap = new LinkedHashMap<String, JSONObject>();
        if (users != null) {
            for (int i = 0; i < users.length; ++i) {
                JSONObject userObject = new JSONObject();
                userObject.put((Object)"userName", (Object)users[i].getTUser());
                userMap.put(String.valueOf(i), userObject);
            }
        }
        return JSONObject.toJSONString(userMap);
    }

    public static String getTaskDefinition(TaskInfoType taskInfoType) {
        return taskInfoType.getDefinitionInfo().getDefinition().getExtraElement().toString();
    }

    public static String prettyPrint(String taskDefinitionRawXml) {
        String tRawXML = taskDefinitionRawXml;
        tRawXML = tRawXML.replaceAll("\n|\\r|\\f|\\t", "");
        tRawXML = tRawXML.replaceAll("> +<", "><");
        ByteArrayInputStream xmlIn = new ByteArrayInputStream(tRawXML.getBytes());
        XMLPrettyPrinter xmlPrettyPrinter = new XMLPrettyPrinter((InputStream)xmlIn);
        tRawXML = xmlPrettyPrinter.xmlFormat();
        return tRawXML;
    }

    public static String getTaskListURL(String client) {
        if ("gadget".equals(client)) {
            return "/humantask/task-list-gadget-ajaxprocessor.jsp";
        }
        if ("carbon".equals(client)) {
            return "/humantask/task_list.jsp";
        }
        return "";
    }
}

