/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.ui.fileupload;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ArchiveExtractor {
    private static Log log = LogFactory.getLog(ArchiveExtractor.class);

    private ArchiveExtractor() {
    }

    private static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        out.close();
    }

    public static void extract(File file, String destination) throws Exception {
        try {
            ZipEntry entry;
            ZipInputStream zipStream = new ZipInputStream(new FileInputStream(file));
            while ((entry = zipStream.getNextEntry()) != null) {
                File destFile;
                if (entry.isDirectory()) {
                    File tempDir;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Extracting directory " + entry.getName()));
                    }
                    if (!(tempDir = new File(destination, entry.getName())).getParentFile().exists() && !tempDir.getParentFile().mkdirs()) {
                        String errMsg = "Error occurred while creating directory: " + tempDir.getParentFile() + " while extracting the archive: " + file.getName();
                        log.error((Object)errMsg);
                        throw new Exception(errMsg);
                    }
                    if (tempDir.exists() || tempDir.mkdir()) continue;
                    String errMsg = "Error occurred while creating directory: " + entry.getName() + " while extracting the archive: " + file.getName();
                    log.error((Object)errMsg);
                    throw new Exception(errMsg);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Extracting file " + entry.getName()));
                }
                if (!(destFile = new File(destination, entry.getName())).getParentFile().exists() && !destFile.getParentFile().mkdirs()) {
                    String errMsg = "Creating directory: " + destFile.getParentFile().getName() + " while extracting the archive: " + file.getName();
                    log.error((Object)errMsg);
                    throw new Exception(errMsg);
                }
                ArchiveExtractor.copyInputStream(zipStream, new BufferedOutputStream(new FileOutputStream(destFile)));
            }
            zipStream.close();
        }
        catch (IOException e) {
            log.error((Object)"Error occurred during archive extracting.", (Throwable)e);
            throw new Exception("Error occurred during archive extracting.", e);
        }
    }
}

