/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.ui.clients;

import java.math.BigInteger;
import java.rmi.RemoteException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.databinding.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.humantask.stub.ui.task.client.api.HumanTaskClientAPIAdminStub;
import org.wso2.carbon.humantask.stub.ui.task.client.api.IllegalAccessFault;
import org.wso2.carbon.humantask.stub.ui.task.client.api.IllegalArgumentFault;
import org.wso2.carbon.humantask.stub.ui.task.client.api.IllegalOperationFault;
import org.wso2.carbon.humantask.stub.ui.task.client.api.IllegalStateFault;
import org.wso2.carbon.humantask.stub.ui.task.client.api.RecipientNotAllowedException;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TAttachmentInfo;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TComment;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TOrganizationalEntity;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TOrganizationalEntityChoice;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TPriority;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TSimpleQueryInput;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TTaskAbstract;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TTaskAuthorisationParams;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TTaskEvents;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TTaskSimpleQueryResultSet;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TUser;
import org.wso2.carbon.humantask.ui.clients.HumanTaskPackageManagementServiceClient;

public class HumanTaskClientAPIServiceClient {
    private static Log log = LogFactory.getLog(HumanTaskPackageManagementServiceClient.class);
    private HumanTaskClientAPIAdminStub stub;

    public HumanTaskClientAPIServiceClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws AxisFault {
        String serviceURL = backendServerURL + "HumanTaskClientAPIAdmin";
        this.stub = new HumanTaskClientAPIAdminStub(configContext, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
    }

    public TTaskSimpleQueryResultSet taskListQuery(TSimpleQueryInput queryInput) throws RemoteException, IllegalArgumentFault, IllegalStateFault {
        try {
            return this.stub.simpleQuery(queryInput);
        }
        catch (RemoteException e) {
            log.error((Object)"Error occurred while performing taskListQuery operation", (Throwable)e);
            throw e;
        }
        catch (IllegalStateFault illegalStateFault) {
            log.error((Object)"Error occurred while performing taskListQuery operation", (Throwable)illegalStateFault);
            throw illegalStateFault;
        }
        catch (IllegalArgumentFault illegalArgumentFault) {
            log.error((Object)"Error occurred while performing taskListQuery operation", (Throwable)illegalArgumentFault);
            throw illegalArgumentFault;
        }
    }

    public TTaskAbstract loadTask(URI taskId) throws RemoteException, IllegalAccessFault {
        try {
            return this.stub.loadTask(taskId);
        }
        catch (RemoteException e) {
            log.error((Object)"Error occurred while performing loadTask operation", (Throwable)e);
            throw e;
        }
        catch (IllegalAccessFault illegalAccessFault) {
            log.error((Object)"Error occurred while performing loadTask operation", (Throwable)illegalAccessFault);
            throw illegalAccessFault;
        }
    }

    public boolean addAttachment(String taskID, String attachmentName, String contentType, String attachmentID) throws RemoteException, IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault, URI.MalformedURIException {
        String errorMsg = "Error occurred while performing addAttachment operation.";
        try {
            log.warn((Object)"Some of the attributes(like accessType) defined in the Service WSDLs are ignored and nulls are passed from to the service call");
            return this.stub.addAttachment(new URI(taskID), attachmentName, "dummyAccessType", contentType, (Object)attachmentID);
        }
        catch (RemoteException e) {
            log.error((Object)errorMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalStateFault e) {
            log.error((Object)errorMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalOperationFault e) {
            log.error((Object)errorMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentFault e) {
            log.error((Object)errorMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalAccessFault e) {
            log.error((Object)errorMsg, (Throwable)e);
            throw e;
        }
        catch (URI.MalformedURIException e) {
            String errorMessage = errorMsg + " TaskId: \"" + taskID + "\"";
            log.error((Object)errorMsg, (Throwable)e);
            throw e;
        }
    }

    public TAttachmentInfo[] getAttachmentInfos(URI taskId) throws RemoteException, IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        String errorMsg = "Error occurred while performing getAttachments operation";
        try {
            return this.stub.getAttachmentInfos(taskId);
        }
        catch (RemoteException e) {
            log.error((Object)errorMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalStateFault e) {
            log.error((Object)errorMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalOperationFault e) {
            log.error((Object)errorMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentFault e) {
            log.error((Object)errorMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalAccessFault e) {
            log.error((Object)errorMsg, (Throwable)e);
            throw e;
        }
    }

    public void complete(URI taskId, String payLoad) throws RemoteException, IllegalAccessFault, IllegalArgumentFault, IllegalStateFault, IllegalOperationFault, XMLStreamException {
        String errMsg = "Error occurred while performing complete operation";
        try {
            this.stub.complete(taskId, payLoad);
        }
        catch (RemoteException e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalAccessFault illegalAccessFault) {
            log.error((Object)errMsg, (Throwable)illegalAccessFault);
            throw illegalAccessFault;
        }
        catch (IllegalArgumentFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalStateFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalOperationFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
    }

    public OMElement loadTaskInput(URI taskId) throws RemoteException, IllegalStateFault, IllegalOperationFault, IllegalAccessFault, IllegalArgumentFault, XMLStreamException {
        String errMsg = "Error occurred while performing loadTaskInput operation";
        try {
            String input = (String)this.stub.getInput(taskId, null);
            return AXIOMUtil.stringToOM((String)input);
        }
        catch (RemoteException e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalStateFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalOperationFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalAccessFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (XMLStreamException e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
    }

    public OMElement loadTaskOutput(URI taskId) throws RemoteException, IllegalStateFault, IllegalOperationFault, IllegalAccessFault, IllegalArgumentFault, XMLStreamException {
        String errMsg = "Error occurred while performing loadTaskOutput operation";
        try {
            String output = (String)this.stub.getOutput(taskId, null);
            return AXIOMUtil.stringToOM((String)output);
        }
        catch (RemoteException e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalStateFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalOperationFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalAccessFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (XMLStreamException e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
    }

    public void claim(URI taskId) throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault, RemoteException, IllegalOperationFault {
        String errMsg = "Error occurred while performing claim operation";
        try {
            this.stub.claim(taskId);
        }
        catch (RemoteException e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalStateFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalOperationFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalAccessFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
    }

    public TTaskAuthorisationParams getTaskParams(URI taskId) throws RemoteException, IllegalStateFault, IllegalArgumentFault {
        String errMsg = "Error occurred while performing getTaskParams operation";
        try {
            return this.stub.loadAuthorisationParams(taskId);
        }
        catch (RemoteException e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalStateFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
    }

    public void start(URI taskId) throws RemoteException, IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        String errMsg = "Error occurred while performing start operation";
        try {
            this.stub.start(taskId);
        }
        catch (RemoteException e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalStateFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalOperationFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalAccessFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
    }

    public void stop(URI taskId) throws RemoteException, IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        String errMsg = "Error occurred while performing stop operation";
        try {
            this.stub.stop(taskId);
        }
        catch (RemoteException e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalStateFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalOperationFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalAccessFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
    }

    public void release(URI taskId) throws RemoteException, IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        String errMsg = "Error occurred while performing release operation";
        try {
            this.stub.release(taskId);
        }
        catch (RemoteException e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalStateFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalOperationFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalAccessFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
    }

    public TTaskEvents getTaskEvents(URI taskId) throws RemoteException, IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        try {
            return this.stub.loadTaskEvents(taskId);
        }
        catch (RemoteException e) {
            log.error((Object)"Error occurred while performing get comments operation", (Throwable)e);
            throw e;
        }
        catch (IllegalStateFault e) {
            log.error((Object)"Error occurred while performing get comments operation", (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentFault e) {
            log.error((Object)"Error occurred while performing get comments operation", (Throwable)e);
            throw e;
        }
    }

    public TComment[] getComments(URI taskId) throws RemoteException, IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        String errMsg = "Error occurred while performing get comments operation";
        try {
            return this.stub.getComments(taskId);
        }
        catch (RemoteException e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalStateFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalOperationFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalAccessFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
    }

    public URI addComment(URI taskId, String commentText) throws RemoteException, IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        String errMsg = "Error occurred while performing add comment operation";
        try {
            return this.stub.addComment(taskId, commentText);
        }
        catch (RemoteException e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalStateFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalOperationFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalAccessFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
    }

    public void deleteComment(URI taskId, URI commentId) throws RemoteException, IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        String errMsg = "Error occurred while performing delete comment operation";
        try {
            this.stub.deleteComment(taskId, commentId);
        }
        catch (RemoteException e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalStateFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalOperationFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalAccessFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
    }

    public void suspend(URI taskId) throws RemoteException, IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        String errMsg = "Error occurred while performing suspend operation";
        try {
            this.stub.suspend(taskId);
        }
        catch (RemoteException e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalStateFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalOperationFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalAccessFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
    }

    public void resume(URI taskId) throws RemoteException, IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        String errMsg = "Error occurred while performing resume operation";
        try {
            this.stub.resume(taskId);
        }
        catch (RemoteException e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalStateFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalOperationFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalAccessFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
    }

    public TUser[] getTaskAssignableUsers(URI taskId) throws RemoteException, IllegalStateFault, IllegalOperationFault, IllegalArgumentFault {
        String errMsg = "Error occurred while performing getTaskAssignableUsers operation";
        try {
            return this.stub.getAssignableUserList(taskId);
        }
        catch (RemoteException e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalStateFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
    }

    public void delegate(URI taskId, String delegatee) throws RemoteException, IllegalStateFault, IllegalArgumentFault, IllegalOperationFault, RecipientNotAllowedException, IllegalAccessFault {
        if (delegatee == null || "".equals(delegatee.trim())) {
            throw new IllegalArgumentException("Delegatee user name should not be empty.");
        }
        String errMsg = "Error occurred while performing delegate operation";
        TOrganizationalEntity delegateOrgEntity = new TOrganizationalEntity();
        TOrganizationalEntityChoice[] delegateArr = new TOrganizationalEntityChoice[1];
        TOrganizationalEntityChoice delegateeChoice = new TOrganizationalEntityChoice();
        TUser delegateeUser = new TUser();
        delegateeUser.setTUser(delegatee);
        delegateeChoice.setUser(delegateeUser);
        delegateArr[0] = delegateeChoice;
        delegateOrgEntity.setTOrganizationalEntityChoice(delegateArr);
        try {
            this.stub.delegate(taskId, delegateOrgEntity);
        }
        catch (RemoteException e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalStateFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalOperationFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (RecipientNotAllowedException e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalAccessFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
    }

    public void skip(URI taskId) throws IllegalArgumentFault, IllegalOperationFault, IllegalAccessFault, IllegalStateFault, RemoteException {
        String errMsg = "Error occurred while performing skip operation";
        try {
            this.stub.skip(taskId);
        }
        catch (RemoteException e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalStateFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalOperationFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalAccessFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
    }

    public void fail(URI taskId) throws IllegalArgumentFault, IllegalOperationFault, IllegalAccessFault, IllegalStateFault, RemoteException {
        String errMsg = "Error occurred while performing fail operation";
        try {
            this.stub.fail(taskId, null);
        }
        catch (RemoteException e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalStateFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalOperationFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalAccessFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
    }

    public void remove(URI taskId) throws IllegalArgumentFault, IllegalOperationFault, IllegalAccessFault, RemoteException {
        String errMsg = "Error occurred while performing resume operation";
        try {
            this.stub.remove(taskId);
        }
        catch (RemoteException e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalOperationFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalAccessFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
    }

    public void changePriority(URI taskId, int priorityInt) throws IllegalArgumentFault, IllegalOperationFault, IllegalAccessFault, RemoteException, IllegalStateFault {
        String errMsg = "Error occurred while performing change priority operation.";
        try {
            TPriority priority = new TPriority();
            priority.setTPriority(BigInteger.valueOf(priorityInt));
            this.stub.setPriority(taskId, priority);
        }
        catch (RemoteException e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalOperationFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalAccessFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        catch (IllegalStateFault e) {
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
    }
}

