/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.deployer.services;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import javax.activation.DataHandler;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.common.UploadedFileItem;
import org.wso2.carbon.humantask.core.HumanTaskConstants;
import org.wso2.carbon.utils.CarbonUtils;

public class HumanTaskUploader
extends AbstractAdmin {
    private static Log log = LogFactory.getLog(HumanTaskUploader.class);

    public void uploadHumanTask(UploadedFileItem[] fileItems) throws AxisFault {
        ConfigurationContext configurationContext = this.getConfigContext();
        String repo = configurationContext.getAxisConfiguration().getRepository().getPath();
        if (CarbonUtils.isURL((String)repo)) {
            throw new AxisFault("URL Repositories are not supported: " + repo);
        }
        String humantaskDirectory = this.getHumanTaskLocation(repo);
        String humantaskTemp = CarbonUtils.getCarbonHome() + File.separator + HumanTaskConstants.HUMANTASK_PACKAGE_TEMP_DIRECTORY;
        File humantaskTempDir = new File(humantaskTemp);
        if (!humantaskTempDir.exists() && !humantaskTempDir.mkdirs()) {
            throw new AxisFault("Fail to create the directory: " + humantaskTempDir.getAbsolutePath());
        }
        File humantaskDir = new File(humantaskDirectory);
        if (!humantaskDir.exists() && !humantaskDir.mkdirs()) {
            throw new AxisFault("Fail to create the directory: " + humantaskDir.getAbsolutePath());
        }
        for (UploadedFileItem uploadedFile : fileItems) {
            String fileName = uploadedFile.getFileName();
            if (fileName == null || fileName.equals("")) {
                throw new AxisFault("Invalid file name. File name is not available");
            }
            if ("zip".equals(uploadedFile.getFileType())) {
                try {
                    this.writeResource(uploadedFile.getDataHandler(), humantaskTemp, fileName, humantaskDir);
                    continue;
                }
                catch (IOException e) {
                    throw new AxisFault("IOError: Writing resource failed.", (Throwable)e);
                }
            }
            throw new AxisFault("Invalid file type : " + uploadedFile.getFileType() + " ." + "zip" + " file type is expected");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeResource(DataHandler dataHandler, String destPath, String fileName, File bpelDest) throws IOException {
        File destFile = new File(destPath, fileName);
        FileOutputStream fos = null;
        FileChannel out = null;
        FileChannel in = null;
        try {
            fos = new FileOutputStream(destFile);
            dataHandler.writeTo((OutputStream)fos);
            out = new FileOutputStream(bpelDest + File.separator + fileName).getChannel();
            in = new FileInputStream(destFile).getChannel();
            out.write(in.map(FileChannel.MapMode.READ_ONLY, 0L, in.size()));
        }
        catch (FileNotFoundException e) {
            try {
                log.error((Object)"Cannot find the file", (Throwable)e);
                throw e;
                catch (IOException e2) {
                    log.error((Object)"IO error.");
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                HumanTaskUploader.close(in);
                HumanTaskUploader.close(out);
                HumanTaskUploader.close(fos);
                throw throwable;
            }
        }
        HumanTaskUploader.close(in);
        HumanTaskUploader.close(out);
        HumanTaskUploader.close(fos);
        boolean isDeleted = destFile.delete();
        if (!isDeleted) {
            log.warn((Object)("temp file: " + destFile.getAbsolutePath() + " deletion failed, scheduled deletion on server exit."));
            destFile.deleteOnExit();
        }
    }

    public static void close(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException e) {
            log.warn((Object)"Can't close file streams.", (Throwable)e);
        }
    }

    private String getHumanTaskLocation(String repoLocation) {
        if (repoLocation.endsWith(File.separator)) {
            return repoLocation + "humantasks";
        }
        return repoLocation + File.separator + "humantasks";
    }
}

