/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.deployer;

import java.io.File;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.humantask.core.HumanTaskServer;
import org.wso2.carbon.humantask.core.deployment.ArchiveBasedHumanTaskDeploymentUnitBuilder;
import org.wso2.carbon.humantask.core.deployment.HumanTaskDeploymentException;
import org.wso2.carbon.humantask.core.deployment.HumanTaskDeploymentUnit;
import org.wso2.carbon.humantask.core.store.HumanTaskStore;
import org.wso2.carbon.humantask.deployer.internal.HumanTaskDeployerServiceComponent;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class HumanTaskDeployer
extends AbstractDeployer {
    private static Log log = LogFactory.getLog(HumanTaskDeployer.class);
    private HumanTaskStore humanTaskStore;

    public void init(ConfigurationContext configurationContext) {
        int tenantId = MultitenantUtils.getTenantId((ConfigurationContext)configurationContext);
        log.info((Object)("Initializing HumanTask Deployer for tenant " + tenantId + "."));
        HumanTaskDeployerServiceComponent.getTenantRegistryLoader().loadTenantRegistry(MultitenantUtils.getTenantId((ConfigurationContext)configurationContext));
        try {
            this.createHumanTaskRepository(configurationContext);
        }
        catch (DeploymentException e) {
            log.warn((Object)String.format("Human Task Repository creation failed for tenant id [%d]", tenantId), (Throwable)e);
        }
        HumanTaskServer humantaskServer = HumanTaskDeployerServiceComponent.getHumanTaskServer();
        this.humanTaskStore = humantaskServer.getTaskStoreManager().createHumanTaskStoreForTenant(tenantId, configurationContext);
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        log.info((Object)String.format("Deploying HumanTask archive with name [%s]", deploymentFileData.getName()));
        try {
            this.humanTaskStore.deploy(this.createHumanTaskDeploymentUnit(deploymentFileData.getFile()));
        }
        catch (Exception e) {
            String errorMessage = "Error deploying HumanTask package: " + deploymentFileData.getName();
            log.error((Object)errorMessage, (Throwable)e);
            throw new DeploymentException(errorMessage, (Throwable)e);
        }
    }

    public void setDirectory(String s) {
    }

    public void setExtension(String s) {
    }

    public void undeploy(String unDeployedFilePath) throws DeploymentException {
        if (StringUtils.isNotEmpty((String)unDeployedFilePath)) {
            File unDeployedFile = new File(unDeployedFilePath);
            String unDeployedPackageName = FilenameUtils.removeExtension((String)unDeployedFile.getName());
            this.humanTaskStore.unDeploy(unDeployedPackageName);
        }
    }

    private void createHumanTaskRepository(ConfigurationContext configCtx) throws DeploymentException {
        boolean status;
        String axisRepoPath = configCtx.getAxisConfiguration().getRepository().getPath();
        if (CarbonUtils.isURL((String)axisRepoPath)) {
            throw new DeploymentException("URL Repositories are not supported: " + axisRepoPath);
        }
        File tenantsRepository = new File(axisRepoPath);
        File humanTaskRepo = new File(tenantsRepository, "humantasks");
        if (!humanTaskRepo.exists() && !(status = humanTaskRepo.mkdir())) {
            throw new DeploymentException("Failed to create HumanTask repository directory " + humanTaskRepo.getAbsolutePath() + ".");
        }
    }

    private HumanTaskDeploymentUnit createHumanTaskDeploymentUnit(File humantaskFile) throws HumanTaskDeploymentException {
        ArchiveBasedHumanTaskDeploymentUnitBuilder humanTaskArchiveProcessor = new ArchiveBasedHumanTaskDeploymentUnitBuilder(humantaskFile, this.humanTaskStore.getTenantId());
        return humanTaskArchiveProcessor.createNewHumanTaskDeploymentUnit();
    }
}

