/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.cleanup.scheduler.util;

import java.util.LinkedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.humantask.cleanup.scheduler.internal.HumanTaskCleanupSchedulerServiceComponent;
import org.wso2.carbon.humantask.cleanup.scheduler.ntask.RemovableTaskCleanupJob;
import org.wso2.carbon.humantask.core.configuration.HumanTaskServerConfiguration;
import org.wso2.carbon.humantask.core.engine.HumanTaskServerException;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.wso2.carbon.ntask.core.TaskManager;

public final class TaskCleanupSchedulerUtil {
    private static Log log = LogFactory.getLog(TaskCleanupSchedulerUtil.class);

    private TaskCleanupSchedulerUtil() {
    }

    public static void initTaskCleanupJob() throws HumanTaskServerException {
        HumanTaskServerConfiguration serverConfig = HumanTaskCleanupSchedulerServiceComponent.getHumanTaskServer().getServerConfig();
        if (serverConfig.isTaskCleanupEnabled()) {
            try {
                log.info((Object)"Initialising the task cleanup service.....");
                HumanTaskCleanupSchedulerServiceComponent.getTaskService().registerTaskType("humantaskType");
                SuperTenantCarbonContext.getCurrentContext().setTenantId(-1234);
                TaskManager taskManager = HumanTaskCleanupSchedulerServiceComponent.getTaskService().getTaskManager("humantaskType");
                TaskInfo taskInfo = new TaskInfo();
                taskInfo.setName("humantaskCleanupJob");
                taskInfo.setTaskClass(RemovableTaskCleanupJob.class.getName());
                TaskInfo.TriggerInfo triggerInfo = new TaskInfo.TriggerInfo();
                triggerInfo.setCronExpression(serverConfig.getTaskCleanupCronExpression());
                taskInfo.setTriggerInfo(triggerInfo);
                LinkedHashMap propertyMap = new LinkedHashMap();
                taskInfo.setProperties(propertyMap);
                taskManager.registerTask(taskInfo);
                taskManager.rescheduleTask("humantaskCleanupJob");
            }
            catch (TaskException ex) {
                String errMsg = "Error occurred while registering task type : humantaskType";
                throw new HumanTaskServerException(errMsg, (Exception)((Object)ex));
            }
        }
    }

    public static void deleteTaskCleanupScheduledJob() {
        try {
            SuperTenantCarbonContext.getCurrentContext().setTenantId(-1234);
            TaskManager taskManager = HumanTaskCleanupSchedulerServiceComponent.getTaskService().getTaskManager("humantaskType");
            if (taskManager != null) {
                for (TaskInfo task : taskManager.getAllTasks()) {
                    taskManager.deleteTask(task.getName());
                }
            }
        }
        catch (TaskException ex) {
            log.warn((Object)"Unable to clean-up scheduled tasks", (Throwable)ex);
        }
    }
}

