/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.cleanup.scheduler.ntask;

import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.humantask.cleanup.scheduler.internal.HumanTaskCleanupSchedulerServiceComponent;
import org.wso2.carbon.humantask.core.configuration.HumanTaskServerConfiguration;
import org.wso2.carbon.humantask.core.dao.HumanTaskDAOConnection;
import org.wso2.carbon.humantask.core.dao.SimpleQueryCriteria;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskRuntimeException;
import org.wso2.carbon.ntask.core.AbstractTask;

public class RemovableTaskCleanupJob
extends AbstractTask {
    private static Log log = LogFactory.getLog(RemovableTaskCleanupJob.class);

    public void execute() {
        HumanTaskServerConfiguration serverConfiguration = HumanTaskCleanupSchedulerServiceComponent.getHumanTaskServer().getServerConfig();
        final SimpleQueryCriteria queryCriteria = this.createQueryCriteria(serverConfiguration);
        log.info((Object)"Running the task cleanup service.....");
        try {
            HumanTaskCleanupSchedulerServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    HumanTaskDAOConnection daoConnection = HumanTaskCleanupSchedulerServiceComponent.getHumanTaskServer().getDaoConnectionFactory().getConnection();
                    daoConnection.removeTasks(queryCriteria);
                    return null;
                }
            });
        }
        catch (Exception ex) {
            String errMsg = "Task Cleanup operation failed! :";
            log.error((Object)errMsg, (Throwable)ex);
            throw new HumanTaskRuntimeException(errMsg, (Throwable)ex);
        }
    }

    private SimpleQueryCriteria createQueryCriteria(HumanTaskServerConfiguration serverConfiguration) {
        SimpleQueryCriteria queryCriteria = new SimpleQueryCriteria();
        queryCriteria.setSimpleQueryType(SimpleQueryCriteria.QueryType.REMOVE_TASKS);
        queryCriteria.setStatuses(serverConfiguration.getRemovableTaskStatuses());
        return queryCriteria;
    }
}

