/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.cleanup.scheduler.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.humantask.cleanup.scheduler.internal.HumanTaskCleanupSchedulerContentHolder;
import org.wso2.carbon.humantask.cleanup.scheduler.util.TaskCleanupSchedulerUtil;
import org.wso2.carbon.humantask.core.HumanTaskEngineService;
import org.wso2.carbon.humantask.core.HumanTaskServer;
import org.wso2.carbon.ntask.core.service.TaskService;

public class HumanTaskCleanupSchedulerServiceComponent {
    private static Log log = LogFactory.getLog(HumanTaskCleanupSchedulerServiceComponent.class);

    protected void activate(ComponentContext ctxt) {
        try {
            log.info((Object)"Starting HumanTaskCleanupSchedulerServiceComponent");
            TaskCleanupSchedulerUtil.initTaskCleanupJob();
            log.info((Object)"Started HumanTaskCleanupSchedulerServiceComponent");
        }
        catch (Throwable t) {
            log.error((Object)"Failed to activate the HumanTaskCleanupSchedulerServiceComponent", t);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"HumanTaskCleanupSchedulerServiceComponent bundle is activated.");
        }
    }

    protected void setHumanTaskServer(HumanTaskEngineService humantaskEngineService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"HumanTaskEngineService bound to the HumanTask Cleanup component");
        }
        HumanTaskCleanupSchedulerContentHolder.getInstance().setHumanTaskServer(humantaskEngineService);
    }

    protected void unsetHumanTaskServer(HumanTaskEngineService humantaskEngineService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"HumanTaskServerService unbound from the HumanTask cleanup component");
        }
        HumanTaskCleanupSchedulerContentHolder.getInstance().setHumanTaskServer(null);
    }

    public static HumanTaskServer getHumanTaskServer() {
        return HumanTaskCleanupSchedulerContentHolder.getInstance().getHumanTaskServer();
    }

    protected void setTaskService(TaskService taskService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Task Service for Humantask Cleanup component");
        }
        HumanTaskCleanupSchedulerContentHolder.getInstance().setTaskService(taskService);
    }

    protected void unsetTaskService(TaskService taskService) {
        TaskCleanupSchedulerUtil.deleteTaskCleanupScheduledJob();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the Task Service for Humantask Cleanup component");
        }
        HumanTaskCleanupSchedulerContentHolder.getInstance().setTaskService(null);
    }

    public static TaskService getTaskService() {
        return HumanTaskCleanupSchedulerContentHolder.getInstance().getTaskService();
    }
}

