/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.hive.data.source.access.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveContext;
import org.apache.hadoop.hive.metastore.hooks.JDOConnectionURLHook;
import org.w3c.dom.Element;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.core.DataSourceService;
import org.wso2.carbon.ndatasource.core.utils.DataSourceUtils;
import org.wso2.carbon.ndatasource.rdbms.RDBMSConfiguration;
import org.wso2.carbon.ndatasource.rdbms.RDBMSDataSourceReader;
import org.wso2.carbon.rssmanager.core.RSSManagerException;
import org.wso2.carbon.rssmanager.core.entity.DatabaseMetaData;
import org.wso2.carbon.rssmanager.core.service.RSSManagerService;

public class DataSourceAccessUtil
implements JDOConnectionURLHook {
    private static final String HIVE_METASTORE_DB = "metastore_db";
    private static DataSourceService carbonDataSourceService;
    private static RSSManagerService rssManagerService;

    public static DataSourceService getCarbonDataSourceService() {
        return carbonDataSourceService;
    }

    public static void setCarbonDataSourceService(DataSourceService dataSourceService) {
        carbonDataSourceService = dataSourceService;
    }

    public static void setRSSManagerService(RSSManagerService rssMgrService) {
        rssManagerService = rssMgrService;
    }

    public static RSSManagerService getRSSManagerService() {
        return rssManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getDataSourceProperties(String dataSourceName) {
        int tenantId = HiveContext.getCurrentContext().getTenantId();
        Map<String, String> dataSourceProperties = new HashMap<String, String>();
        try {
            SuperTenantCarbonContext.startTenantFlow();
            SuperTenantCarbonContext.getCurrentContext().setTenantId(tenantId);
            Element element = (Element)carbonDataSourceService.getDataSource(dataSourceName).getDSMInfo().getDefinition().getDsXMLConfiguration();
            RDBMSConfiguration rdbmsConfiguration = RDBMSDataSourceReader.loadConfig((String)DataSourceUtils.elementToString((Element)element));
            dataSourceProperties = DataSourceAccessUtil.setDataSourceProperties(dataSourceProperties, rdbmsConfiguration);
        }
        catch (DataSourceException e) {
            e.printStackTrace();
        }
        finally {
            SuperTenantCarbonContext.endTenantFlow();
        }
        return dataSourceProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMetaStoreConnectionURL(int tenantId) {
        try {
            DatabaseMetaData[] databaseEntries;
            SuperTenantCarbonContext.startTenantFlow();
            SuperTenantCarbonContext.getCurrentContext().setTenantId(tenantId);
            for (DatabaseMetaData databaseEntry : databaseEntries = rssManagerService.getDatabases()) {
                if (!databaseEntry.getName().contains(HIVE_METASTORE_DB)) continue;
                String string = databaseEntry.getUrl();
                return string;
            }
        }
        catch (RSSManagerException e) {
            e.printStackTrace();
        }
        finally {
            SuperTenantCarbonContext.endTenantFlow();
        }
        return null;
    }

    public String getJdoConnectionUrl(Configuration configuration) throws Exception {
        int tenantId = configuration.getInt("hive.current.tenant", -1234);
        return DataSourceAccessUtil.getMetaStoreConnectionURL(tenantId);
    }

    public void notifyBadConnectionUrl(String s) {
    }

    private static Map<String, String> setDataSourceProperties(Map<String, String> dataSourceProperties, RDBMSConfiguration rdbmsConfiguration) {
        DataSourceAccessUtil.setProperties("mapred.jdbc.url", rdbmsConfiguration.getUrl(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("mapred.jdbc.driver.class", rdbmsConfiguration.getDriverClassName(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("mapred.jdbc.username", rdbmsConfiguration.getUsername(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("mapred.jdbc.password", rdbmsConfiguration.getPassword(), dataSourceProperties);
        return dataSourceProperties;
    }

    private static void setProperties(String propertyKey, Object value, Map<String, String> dataSourceProperties) {
        if (value != null) {
            if (value instanceof Boolean) {
                dataSourceProperties.put(propertyKey, Boolean.toString((Boolean)value));
            } else if (value instanceof String) {
                dataSourceProperties.put(propertyKey, (String)value);
            } else if (value instanceof Integer) {
                dataSourceProperties.put(propertyKey, Integer.toString((Integer)value));
            } else if (value instanceof Long) {
                dataSourceProperties.put(propertyKey, Long.toString((Long)value));
            }
        }
    }
}

