/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.hive.data.source.access.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.hive.data.source.access.util.DataSourceAccessUtil;
import org.wso2.carbon.ndatasource.core.DataSourceService;
import org.wso2.carbon.rssmanager.core.service.RSSManagerService;

public class DataSourceAccessComponent {
    private static Log log = LogFactory.getLog(DataSourceAccessComponent.class);

    protected void activate(ComponentContext ctxt) {
        try {
            log.debug((Object)"Hive DataSource access bundle is activated ");
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        log.debug((Object)"Hive DataSource access bundle is deactivated ");
    }

    protected void setDataSourceService(DataSourceService dataSourceService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Carbon Data Sources Service");
        }
        DataSourceAccessUtil.setCarbonDataSourceService(dataSourceService);
    }

    protected void unsetDataSourceService(DataSourceService dataSourceService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the Carbon Data Sources Service");
        }
        DataSourceAccessUtil.setCarbonDataSourceService(null);
    }

    protected void setRSSManagerService(RSSManagerService rssManagerService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the RSS Manager Service");
        }
        DataSourceAccessUtil.setRSSManagerService(rssManagerService);
    }

    protected void unsetRSSManagerService(RSSManagerService rssManagerService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unetting the RSS Manager Service");
        }
        DataSourceAccessUtil.setRSSManagerService(null);
    }
}

