/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.hive.data.source.access.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.service.CarbonContextThreadLocal;
import org.w3c.dom.Element;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.core.DataSourceService;
import org.wso2.carbon.ndatasource.core.utils.DataSourceUtils;
import org.wso2.carbon.ndatasource.rdbms.RDBMSConfiguration;
import org.wso2.carbon.ndatasource.rdbms.RDBMSDataSourceReader;

public class DataSourceAccessUtil {
    private static DataSourceService carbonDataSourceService;

    public static DataSourceService getCarbonDataSourceService() {
        return carbonDataSourceService;
    }

    public static void setCarbonDataSourceService(DataSourceService dataSourceService) {
        carbonDataSourceService = dataSourceService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getDataSourceProperties(String dataSourceName) {
        int tenantId = CarbonContextThreadLocal.getTenantId();
        Map<String, String> dataSourceProperties = new HashMap<String, String>();
        try {
            SuperTenantCarbonContext.startTenantFlow();
            SuperTenantCarbonContext.getCurrentContext().setTenantId(tenantId);
            Element element = (Element)carbonDataSourceService.getDataSource(dataSourceName).getDSMInfo().getDefinition().getDsXMLConfiguration();
            RDBMSConfiguration rdbmsConfiguration = RDBMSDataSourceReader.loadConfig((String)DataSourceUtils.elementToString((Element)element));
            dataSourceProperties = DataSourceAccessUtil.setDataSourceProperties(dataSourceProperties, rdbmsConfiguration);
        }
        catch (DataSourceException e) {
            e.printStackTrace();
        }
        finally {
            SuperTenantCarbonContext.endTenantFlow();
        }
        return dataSourceProperties;
    }

    private static Map<String, String> setDataSourceProperties(Map<String, String> dataSourceProperties, RDBMSConfiguration rdbmsConfiguration) {
        DataSourceAccessUtil.setProperties("mapred.jdbc.url", rdbmsConfiguration.getUrl(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("mapred.jdbc.driver.class", rdbmsConfiguration.getDriverClassName(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("mapred.jdbc.username", rdbmsConfiguration.getUsername(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("mapred.jdbc.password", rdbmsConfiguration.getPassword(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("accessToUnderlyingConnectionAllowed", rdbmsConfiguration.isAccessToUnderlyingConnectionAllowed(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("defaultAutoCommit", rdbmsConfiguration.isDefaultAutoCommit(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("defaultCatalog", rdbmsConfiguration.getDefaultCatalog(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("defaultReadOnly", rdbmsConfiguration.isDefaultReadOnly(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("defaultTransactionIsolation", rdbmsConfiguration.getDefaultTransactionIsolation(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("initialSize", rdbmsConfiguration.getInitialSize(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("logAbandoned", rdbmsConfiguration.isLogAbandoned(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("maxActive", rdbmsConfiguration.getMaxActive(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("maxIdle", rdbmsConfiguration.getMaxIdle(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("maxWait", rdbmsConfiguration.getMaxWait(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("minEvictableIdleTimeMillis", rdbmsConfiguration.getMinEvictableIdleTimeMillis(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("minIdle", rdbmsConfiguration.getMinIdle(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("numTestsPerEvictionRun", rdbmsConfiguration.getNumTestsPerEvictionRun(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("removeAbandoned", rdbmsConfiguration.isRemoveAbandoned(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("removeAbandonedTimeout", rdbmsConfiguration.getRemoveAbandonedTimeout(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("testOnBorrow", rdbmsConfiguration.isTestOnBorrow(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("testOnReturn", rdbmsConfiguration.isTestOnReturn(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("testWhileIdle", rdbmsConfiguration.isTestWhileIdle(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("timeBetweenEvictionRunsMillis", rdbmsConfiguration.getTimeBetweenEvictionRunsMillis(), dataSourceProperties);
        DataSourceAccessUtil.setProperties("validationQuery", rdbmsConfiguration.getValidationQuery(), dataSourceProperties);
        return dataSourceProperties;
    }

    private static void setProperties(String propertyKey, Object value, Map<String, String> dataSourceProperties) {
        if (value != null) {
            if (value instanceof Boolean) {
                dataSourceProperties.put(propertyKey, Boolean.toString((Boolean)value));
            } else if (value instanceof String) {
                dataSourceProperties.put(propertyKey, (String)value);
            } else if (value instanceof Integer) {
                dataSourceProperties.put(propertyKey, Integer.toString((Integer)value));
            } else if (value instanceof Long) {
                dataSourceProperties.put(propertyKey, Long.toString((Long)value));
            }
        }
    }
}

