/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.wsdltool.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.wsdltool.stub.WSDLToolServiceStub;
import org.wso2.carbon.governance.wsdltool.stub.beans.xsd.ServiceInfoBean;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.ui.CarbonUIUtil;

public class WSDLToolServiceClient {
    private static final Log log = LogFactory.getLog(WSDLToolServiceClient.class);
    private WSDLToolServiceStub stub;
    private String epr;

    public WSDLToolServiceClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws RegistryException {
        this.epr = backendServerURL + "WSDLToolService";
        try {
            this.stub = new WSDLToolServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate wsdltool service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public WSDLToolServiceClient(ServletConfig config, HttpSession session) throws RegistryException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "WSDLToolService";
        try {
            this.stub = new WSDLToolServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate wsdltool service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public void addMEXService(String path, ServiceInfoBean serviceInfo) throws Exception {
        this.stub.addMEXService(path, serviceInfo);
    }
}

