/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.sramp.internal;

import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpService;
import org.wso2.carbon.governance.sramp.SRAMPServlet;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.ConfigurationContextService;

public class SRAMPServiceComponent {
    private static Log log = LogFactory.getLog(SRAMPServiceComponent.class);
    private RegistryService registryService = null;
    private ConfigurationContextService configurationContextService = null;
    private HttpService httpService = null;

    protected void activate(ComponentContext context) {
        try {
            this.registerServlet(context.getBundleContext());
            log.debug((Object)"******* Governance S-Ramp bundle is activated ******* ");
        }
        catch (Throwable e) {
            log.error((Object)"******* Failed to activate Governance S-Ramp bundle ******* ", e);
        }
    }

    protected void deactivate(ComponentContext context) {
        this.httpService.unregister("/s-ramp");
        log.debug((Object)"******* Governance S-Ramp bundle is deactivated ******* ");
    }

    private void registerServlet(BundleContext bundleContext) throws Exception {
        this.httpService.registerServlet("/s-ramp", (Servlet)new SRAMPServlet(this.configurationContextService, this.registryService), null, this.httpService.createDefaultHttpContext());
    }

    protected void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.registryService = null;
    }

    protected void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    protected void unsetHttpService(HttpService httpService) {
        this.httpService = null;
    }

    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        this.configurationContextService = configurationContextService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        this.configurationContextService = null;
    }
}

