/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.sramp;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Categories;
import org.apache.abdera.model.Collection;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Workspace;
import org.apache.abdera.parser.stax.FOMEntry;
import org.apache.abdera.parser.stax.FOMFeed;
import org.apache.abdera.parser.stax.FOMService;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.services.ServiceFilter;
import org.wso2.carbon.governance.api.services.ServiceManager;
import org.wso2.carbon.governance.api.services.dataobjects.Service;
import org.wso2.carbon.governance.api.wsdls.WsdlManager;
import org.wso2.carbon.governance.api.wsdls.dataobjects.Wsdl;
import org.wso2.carbon.governance.sramp.exceptions.SRAMPServletException;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

public class SRAMPServlet
extends HttpServlet {
    private static final long serialVersionUID = 5371668294418554489L;
    private static final String ATOM_MEDIA_TYPE = "application/atom+xml";
    private static final String XML_MEDIA_TYPE = "text/xml";
    private static final String APPLICATION_ATOMSVC_XML = "application/atomsvc+xml";
    private static final String ATOM_FEED_MEDIA_TYPE = "application/atom+xml; type=feed";
    private static final String ATOM_ENTRY_MEDIA_TYPE = "application/atom+xml; type=entry";
    private static final String UTF8_XML_MEDIA_TYPE = "text/xml; charset=UTF-8";
    private static final String LAST_MODIFIED_HEADER = "Last-Modified";
    private static final String E_TAG_HEADER = "ETag";
    private static final String CONTENT_DISPOSITION_HEADER = "Content-Disposition";
    private static final String SOA_MODEL_SERVICE_INTERFACE_CLASSIFICATION = "http://wso2.org/soaModel#ServiceInterface";
    private static final String SOA_MODEL_SERVICE_CLASSIFICATION = "http://wso2.org/soaModel#Service";
    private static final String CONTENT_ENCODING_ATTRIBUTE = "contentEncoding";
    private static final String UUID_ATTRIBUTE = "uuid";
    private static final String VERSION_ATTRIBUTE = "version";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String CREATED_BY_ATTRIBUTE = "createdBy";
    private static final String CREATED_TIMESTAMP_ATTRIBUTE = "createdTimestamp";
    private static final String LAST_MODIFIED_TIMESTAMP_ATTRIBUTE = "lastModifiedTimestamp";
    private static final String LAST_MODIFIED_BY_ATTRIBUTE = "lastModifiedBy";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String CONTENT_SIZE_ATTRIBUTE = "contentSize";
    private static final String CONTENT_PATH_COMPONENT = "/content";
    private static final String WSDL_WSDL_DOCUMENT_PATH_COMPONENT = "/wsdl/WsdlDocument/";
    private static final String SOA_SERVICE_PATH_COMPONENT = "/soa/Service/";
    private static final String SOA_SERVICE_INTERFACE_PATH_COMPONENT = "/soa/ServiceInterface/";
    private static final String SERVICE_DOCUMENT_PATH_COMPONENT = "/servicedocument";
    private static final String ATTACHMENT_FILENAME = "attachment; filename=";
    private static final String URN_UUID = "urn:uuid:";
    private static final String UTF_8 = "UTF-8";
    private static final String DEFAULT_ARTIFACT_VERSION = "1.0";
    private static final String S_RAMP_SERVLET_CONTEXT = "/s-ramp";
    private static final QName HREF_Q_NAME = new QName("http://www.w3.org/1999/xlink", "href", "xlin");
    private static Log log = LogFactory.getLog(SRAMPServlet.class);
    private String servletURL;
    private transient Abdera abdera = new Abdera();
    private transient UserRegistry governanceSystemRegistry;

    public SRAMPServlet(ConfigurationContextService configurationContextService, RegistryService registryService) throws RegistryException {
        this.governanceSystemRegistry = registryService.getGovernanceSystemRegistry();
        String serverURL = CarbonUtils.getServerURL((ServerConfigurationService)CarbonUtils.getServerConfiguration(), (ConfigurationContext)configurationContextService.getServerConfigContext());
        this.servletURL = serverURL.substring(0, serverURL.lastIndexOf("/services")) + S_RAMP_SERVLET_CONTEXT;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String query = this.getXPathForQuery(req);
        if (query != null) {
            this.processQueryRequest(req, resp, query);
        } else {
            this.processGETRequest(req, resp);
        }
    }

    protected void processGETRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        if (pathInfo.startsWith(WSDL_WSDL_DOCUMENT_PATH_COMPONENT)) {
            this.processGETWSDLDocumentRequest(req, resp, pathInfo.substring(WSDL_WSDL_DOCUMENT_PATH_COMPONENT.length()));
        } else if (pathInfo.startsWith(SOA_SERVICE_PATH_COMPONENT)) {
            this.processGETServiceRequest(req, resp, pathInfo.substring(SOA_SERVICE_PATH_COMPONENT.length()));
        } else if (pathInfo.startsWith(SOA_SERVICE_INTERFACE_PATH_COMPONENT)) {
            this.processGETServiceInterfaceRequest(req, resp, pathInfo.substring(SOA_SERVICE_INTERFACE_PATH_COMPONENT.length()));
        } else if (pathInfo.startsWith(SERVICE_DOCUMENT_PATH_COMPONENT)) {
            this.processGETServiceDocumentRequest(req, resp);
        }
    }

    private void processGETWSDLDocumentRequest(HttpServletRequest req, HttpServletResponse resp, String pathInfo) throws ServletException, IOException {
        String[] pathComponents = pathInfo.split("/");
        if (pathComponents.length == 2 && pathComponents[1].equals(CONTENT_PATH_COMPONENT.substring(1))) {
            this.processGETWSDLContentRequest(resp, pathComponents[0]);
        } else if (pathComponents.length == 1) {
            this.processGETWSDLArtifactRequest(req, resp, pathComponents[0]);
        }
    }

    private void processGETWSDLArtifactRequest(HttpServletRequest req, HttpServletResponse resp, String pathComponent) throws ServletException, IOException {
        Entry entry = this.abdera.newEntry();
        Element artifact = this.newSRAMPArtifact();
        Element wsdlDocument = this.newExtensionElement(artifact, "WsdlDocument");
        wsdlDocument.setAttributeValue(CONTENT_ENCODING_ATTRIBUTE, UTF_8);
        WsdlManager manager = new WsdlManager((Registry)this.governanceSystemRegistry);
        try {
            Wsdl wsdl = manager.getWsdl(pathComponent);
            String wsdlId = wsdl.getId();
            entry.setId(URN_UUID + wsdlId);
            wsdlDocument.setAttributeValue(UUID_ATTRIBUTE, wsdlId);
            wsdlDocument.setAttributeValue(VERSION_ATTRIBUTE, DEFAULT_ARTIFACT_VERSION);
            String path = wsdl.getPath();
            String resourceName = RegistryUtils.getResourceName((String)path);
            entry.setTitle(resourceName);
            wsdlDocument.setAttributeValue(NAME_ATTRIBUTE, resourceName);
            Resource resource = this.getResource(path);
            if (resource != null) {
                this.fillArtifactEntryDetailsFromResource(wsdlDocument, entry, resource);
                this.fillArtifactEntryDescriptionFromResource(wsdlDocument, entry, resource);
                this.fillPropertiesFromResource(wsdlDocument, resource);
                this.fillArtifactEntryContentDetailsFromResource(wsdlDocument, resource);
            }
            String serviceURL = this.getServletURL(req) + WSDL_WSDL_DOCUMENT_PATH_COMPONENT + wsdlId;
            entry.setContent(new IRI(serviceURL + CONTENT_PATH_COMPONENT), XML_MEDIA_TYPE);
            this.addAtomLinksForGETRequest(entry, serviceURL);
            entry.addExtension(artifact);
        }
        catch (GovernanceException e) {
            String message = "Unable to locate WSDL";
            log.error((Object)message, (Throwable)e);
            throw new SRAMPServletException(message, e);
        }
        resp.setContentType(ATOM_ENTRY_MEDIA_TYPE);
        resp.setStatus(200);
        this.serializeOutput(resp, (OMElement)((FOMEntry)entry));
    }

    private void processGETWSDLContentRequest(HttpServletResponse resp, String pathComponent) throws ServletException, IOException {
        WsdlManager manager = new WsdlManager((Registry)this.governanceSystemRegistry);
        try {
            Resource resource;
            Wsdl wsdl = manager.getWsdl(pathComponent);
            if (wsdl == null || wsdl.getWsdlElement() == null) {
                String message = "Unable to retrieve WSDL content for the given id: " + pathComponent;
                log.error((Object)message);
                throw new SRAMPServletException(message);
            }
            String path = wsdl.getPath();
            try {
                resource = this.governanceSystemRegistry.get(path);
            }
            catch (Exception e) {
                resource = null;
            }
            if (resource != null) {
                String errorMessage = "Unable to read content of the WSDL element";
                try {
                    String content;
                    resp.setDateHeader(LAST_MODIFIED_HEADER, resource.getLastModified().getTime());
                    Object temp = resource.getContent();
                    if (temp instanceof String) {
                        content = (String)temp;
                    } else if (temp instanceof byte[]) {
                        content = RegistryUtils.decodeBytes((byte[])((byte[])temp));
                    } else {
                        log.error((Object)errorMessage);
                        throw new SRAMPServletException(errorMessage);
                    }
                    resp.setHeader(E_TAG_HEADER, DigestUtils.md5Hex((String)content));
                }
                catch (RegistryException e) {
                    log.error((Object)errorMessage, (Throwable)e);
                    throw new SRAMPServletException(errorMessage, e);
                }
                resp.setHeader(CONTENT_DISPOSITION_HEADER, ATTACHMENT_FILENAME + RegistryUtils.getResourceName((String)path));
            }
            resp.setContentType(UTF8_XML_MEDIA_TYPE);
            resp.setStatus(200);
            OMElement wsdlElement = wsdl.getWsdlElement();
            OMDocument document = wsdlElement.getOMFactory().createOMDocument();
            document.addChild((OMNode)wsdlElement);
            document.build();
            try {
                document.serialize((OutputStream)resp.getOutputStream());
            }
            catch (XMLStreamException e) {
                String message = "Unable to serialize WSDL content";
                log.error((Object)message, (Throwable)e);
                throw new SRAMPServletException(message, e);
            }
        }
        catch (GovernanceException e) {
            String message = "Unable to locate WSDL";
            log.error((Object)message, (Throwable)e);
            throw new SRAMPServletException(message, e);
        }
    }

    private void processGETServiceRequest(HttpServletRequest req, HttpServletResponse resp, String pathComponent) throws ServletException, IOException {
        Entry entry = this.abdera.newEntry();
        Element artifact = this.newSRAMPArtifact();
        Element serviceElement = this.newExtensionElement(artifact, "Service");
        serviceElement.setAttributeValue(CONTENT_ENCODING_ATTRIBUTE, UTF_8);
        ServiceManager manager = new ServiceManager((Registry)this.governanceSystemRegistry);
        try {
            Service service = manager.getService(pathComponent);
            String serviceId = service.getId();
            entry.setId(URN_UUID + serviceId);
            serviceElement.setAttributeValue(UUID_ATTRIBUTE, serviceId);
            serviceElement.setAttributeValue(VERSION_ATTRIBUTE, DEFAULT_ARTIFACT_VERSION);
            String path = service.getPath();
            String serviceName = service.getQName().getLocalPart();
            entry.setTitle(serviceName);
            serviceElement.setAttributeValue(NAME_ATTRIBUTE, serviceName);
            Resource resource = this.getResource(path);
            if (resource != null) {
                this.fillArtifactEntryDetailsFromResource(serviceElement, entry, resource);
                this.fillArtifactEntryDescriptionFromResource(serviceElement, entry, resource);
                this.fillPropertiesFromResource(serviceElement, resource);
            }
            String serviceURL = this.getServletURL(req) + SOA_SERVICE_PATH_COMPONENT + serviceId;
            entry.setContent("");
            this.addAtomLinksForGETRequest(entry, serviceURL);
            this.newExtensionElement(serviceElement, "classifiedBy").setText(SOA_MODEL_SERVICE_CLASSIFICATION);
            Wsdl[] attachedWsdls = service.getAttachedWsdls();
            if (attachedWsdls.length > 0) {
                StringBuffer buffer = new StringBuffer(serviceId);
                for (Wsdl wsdl : attachedWsdls) {
                    buffer.append(wsdl.getId());
                }
                String serviceInterfaceId = this.uuidForString(buffer.toString());
                Element relationship = this.newExtensionElement(serviceElement, "relationship");
                this.newExtensionElement(relationship, "relationshipType").setText("hasInterface");
                Element relationshipTarget = this.newExtensionElement(relationship, "relationshipTarget");
                relationshipTarget.setText(serviceInterfaceId);
                relationshipTarget.setAttributeValue(HREF_Q_NAME, this.getServletURL(req) + SOA_SERVICE_INTERFACE_PATH_COMPONENT + serviceInterfaceId);
            }
            entry.addExtension(artifact);
        }
        catch (GovernanceException e) {
            String message = "Unable to locate Service";
            log.error((Object)message, (Throwable)e);
            throw new SRAMPServletException(message, e);
        }
        resp.setContentType(ATOM_ENTRY_MEDIA_TYPE);
        resp.setStatus(200);
        this.serializeOutput(resp, (OMElement)((FOMEntry)entry));
    }

    private void processGETServiceInterfaceRequest(HttpServletRequest req, HttpServletResponse resp, String pathComponent) throws ServletException, IOException {
        Entry entry = this.abdera.newEntry();
        Element artifact = this.newSRAMPArtifact();
        Element serviceInterface = this.newExtensionElement(artifact, "ServiceInterface");
        serviceInterface.setAttributeValue(CONTENT_ENCODING_ATTRIBUTE, UTF_8);
        ServiceManager manager = new ServiceManager((Registry)this.governanceSystemRegistry);
        try {
            Service[] services = this.findServiceForInterfaceId(pathComponent, manager);
            if (services.length != 1) {
                String message = "Unable to locate Service for Given Interface";
                log.error((Object)message);
                throw new SRAMPServletException(message);
            }
            Service service = services[0];
            entry.setId(URN_UUID + pathComponent);
            serviceInterface.setAttributeValue(UUID_ATTRIBUTE, pathComponent);
            serviceInterface.setAttributeValue(VERSION_ATTRIBUTE, DEFAULT_ARTIFACT_VERSION);
            String path = service.getPath();
            String serviceName = service.getQName().getLocalPart();
            String serviceInterfaceName = serviceName + " SI";
            entry.setTitle(serviceInterfaceName);
            serviceInterface.setAttributeValue(NAME_ATTRIBUTE, serviceInterfaceName);
            Resource resource = this.getResource(path);
            if (resource != null) {
                this.fillArtifactEntryDetailsFromResource(serviceInterface, entry, resource);
            }
            String summary = serviceName + " service interface";
            serviceInterface.setAttributeValue(DESCRIPTION_ATTRIBUTE, summary);
            entry.setSummary(summary);
            entry.setContent("");
            this.addAtomLinksForGETRequest(entry, this.getServletURL(req) + SOA_SERVICE_INTERFACE_PATH_COMPONENT + pathComponent);
            this.newExtensionElement(serviceInterface, "classifiedBy").setText(SOA_MODEL_SERVICE_INTERFACE_CLASSIFICATION);
            Wsdl[] attachedWsdls = service.getAttachedWsdls();
            if (attachedWsdls.length > 0) {
                for (Wsdl wsdl : attachedWsdls) {
                    Element relationship = this.newExtensionElement(serviceInterface, "relationship");
                    this.newExtensionElement(relationship, "relationshipType").setText("documentation");
                    Element relationshipTarget = this.newExtensionElement(relationship, "relationshipTarget");
                    String wsdlId = wsdl.getId();
                    relationshipTarget.setText(wsdlId);
                    relationshipTarget.setAttributeValue(HREF_Q_NAME, this.getServletURL(req) + WSDL_WSDL_DOCUMENT_PATH_COMPONENT + wsdlId);
                }
            }
            entry.addExtension(artifact);
        }
        catch (GovernanceException e) {
            String message = "Unable to locate Service Interface";
            log.error((Object)message, (Throwable)e);
            throw new SRAMPServletException(message, e);
        }
        resp.setContentType(ATOM_ENTRY_MEDIA_TYPE);
        resp.setStatus(200);
        this.serializeOutput(resp, (OMElement)((FOMEntry)entry));
    }

    private void processGETServiceDocumentRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        org.apache.abdera.model.Service service = this.abdera.newService();
        Factory factory = this.abdera.getFactory();
        String servletURL = this.getServletURL(req);
        service.addWorkspace(this.buildCoreModel(factory, servletURL));
        service.addWorkspace(this.buildSOAPWSDLModel(factory, servletURL));
        service.addWorkspace(this.buildQueryModel(factory, servletURL));
        service.addWorkspace(this.buildXSDModel(factory, servletURL));
        service.addWorkspace(this.buildSOAModel(factory, servletURL));
        service.addWorkspace(this.buildPolicyModel(factory, servletURL));
        service.addWorkspace(this.buildWSDLModel(factory, servletURL));
        service.addWorkspace(this.buildServiceImplementation(factory, servletURL));
        resp.setContentType(APPLICATION_ATOMSVC_XML);
        resp.setStatus(200);
        this.serializeOutput(resp, (OMElement)((FOMService)service));
    }

    private Collection buildParentCollection(Factory factory, String servletURL, Collection[] children, String href, String title) {
        Collection parent = factory.newCollection().setHref(servletURL + href);
        parent.setTitle(title);
        LinkedList categories = new LinkedList();
        for (Collection child : children) {
            categories.add(((Categories)child.getCategories().get(0)).getCategoriesWithScheme().get(0));
        }
        parent.setAcceptsNothing().addCategories(categories, true, null);
        return parent;
    }

    private Collection buildChildCollection(Factory factory, String servletURL, String href, String title, String accept, String label, String term) {
        Collection collection = factory.newCollection().setHref(servletURL + href);
        collection.setTitle(title);
        if (accept != null) {
            collection.setAccept(new String[]{accept});
        } else {
            collection.setAcceptsNothing();
        }
        collection.addCategories(factory.newCategories().setFixed(true).addCategory(factory.newCategory().setScheme("urn:x-s-ramp:2010:type").setTerm(term).setLabel(label)));
        return collection;
    }

    private Workspace buildCoreModel(Factory factory, String servletURL) {
        Collection[] children;
        Workspace coreModel = factory.newWorkspace();
        coreModel.setTitle("Core Model");
        for (Collection child : children = new Collection[]{this.buildChildCollection(factory, servletURL, "/core/XmlDocument", "XML Documents", "application/xml", "XML Document", "XmlDocument"), this.buildChildCollection(factory, servletURL, "/core/document", "Documents", "application/octet-stream", "Document", "Document")}) {
            coreModel.addCollection(child);
        }
        coreModel.addCollection(this.buildParentCollection(factory, servletURL, children, "/core", "Core Model Objects"));
        return coreModel;
    }

    private Workspace buildSOAPWSDLModel(Factory factory, String servletURL) {
        Collection[] children;
        Workspace soapWsdlModel = factory.newWorkspace();
        soapWsdlModel.setTitle("SOAP WSDL Model");
        for (Collection child : children = new Collection[]{this.buildChildCollection(factory, servletURL, "/soapWsdl/SoapBinding", "SOAP Bindings", null, "SOAP Binding", "SoapBinding"), this.buildChildCollection(factory, servletURL, "/soapWsdl/SoapAddress", "SOAP Addresses", null, "SOAP Address", "SoapAddress")}) {
            soapWsdlModel.addCollection(child);
        }
        soapWsdlModel.addCollection(this.buildParentCollection(factory, servletURL, children, "/soapWsdl", "SOAP WSDL Model Objects"));
        return soapWsdlModel;
    }

    private Workspace buildServiceImplementation(Factory factory, String servletURL) {
        Collection[] children;
        Workspace serviceImplementation = factory.newWorkspace();
        serviceImplementation.setTitle("Service Implementation");
        for (Collection child : children = new Collection[]{this.buildChildCollection(factory, servletURL, "/serviceImplementation/ServiceOperation", "Service Operations", ATOM_ENTRY_MEDIA_TYPE, "Service Operation", "ServiceOperation"), this.buildChildCollection(factory, servletURL, "/serviceImplementation/Organization", "Organizations", ATOM_ENTRY_MEDIA_TYPE, "Organization", "Organization"), this.buildChildCollection(factory, servletURL, "/serviceImplementation/ServiceInstance", "Service Instances", ATOM_ENTRY_MEDIA_TYPE, "Service Instance", "ServiceInstance"), this.buildChildCollection(factory, servletURL, "/serviceImplementation/ServiceEndpoint", "Service Endpoints", ATOM_ENTRY_MEDIA_TYPE, "Service Endpoint", "ServiceEndpoint")}) {
            serviceImplementation.addCollection(child);
        }
        serviceImplementation.addCollection(this.buildParentCollection(factory, servletURL, children, "/serviceImplementation", "Service Implementation Objects"));
        return serviceImplementation;
    }

    private Workspace buildXSDModel(Factory factory, String servletURL) {
        Collection[] children;
        Workspace xsdModel = factory.newWorkspace();
        xsdModel.setTitle("XSD Model");
        for (Collection child : children = new Collection[]{this.buildChildCollection(factory, servletURL, "/xsd/XsdType", "XSD Types", null, "XSD Type", "XsdType"), this.buildChildCollection(factory, servletURL, "/xsd/ElementDeclaration", "Element Declarations", null, "Element Declaration", "ElementDeclaration"), this.buildChildCollection(factory, servletURL, "/xsd/AttributeDeclaration", "Attribute Declarations", null, "Attribute Declaration", "AttributeDeclaration"), this.buildChildCollection(factory, servletURL, "/xsd/ComplexTypeDeclaration", "Complex Type Declarations", null, "Complex Type Declaration", "ComplexTypeDeclaration"), this.buildChildCollection(factory, servletURL, "/xsd/SimpleTypeDeclaration", "Simple Type Declarations", null, "Simple Type Declaration", "SimpleTypeDeclaration"), this.buildChildCollection(factory, servletURL, "/xsd/XsdDocument", "XSD Documents", "application/xml", "XSD Document", "XsdDocument")}) {
            xsdModel.addCollection(child);
        }
        xsdModel.addCollection(this.buildParentCollection(factory, servletURL, children, "/xsd", "XSD Model Objects"));
        return xsdModel;
    }

    private Workspace buildSOAModel(Factory factory, String servletURL) {
        Workspace soaModel = factory.newWorkspace();
        soaModel.setTitle("SOA Model");
        String[] types = new String[]{"Service Contract", "Orchestration Process", "Choreography Process", "Service Interface", "Collaboration Process", "Process", "Actor", "Collaboration", "Composition", "Element", "Event", "Orchestration", "Policy Subject", "Effect", "Information Type", "Task", "System", "Service", "Policy", "Choreography"};
        LinkedList<Collection> children = new LinkedList<Collection>();
        for (String type1 : types) {
            String type2 = type1.replace(" ", "");
            Collection child = this.buildChildCollection(factory, servletURL, "/soa/" + type2, type1, ATOM_ENTRY_MEDIA_TYPE, type2, type1);
            soaModel.addCollection(child);
            children.add(child);
        }
        soaModel.addCollection(this.buildParentCollection(factory, servletURL, children.toArray(new Collection[children.size()]), "/soa", "SOA Model Objects"));
        return soaModel;
    }

    private Workspace buildWSDLModel(Factory factory, String servletURL) {
        Collection[] children;
        Workspace wsdlModel = factory.newWorkspace();
        wsdlModel.setTitle("WSDL Model");
        for (Collection child : children = new Collection[]{this.buildChildCollection(factory, servletURL, "/wsdl/BindingOperationOutput", "Binding Operation Outputs", null, "Binding Operation Output", "BindingOperationOutput"), this.buildChildCollection(factory, servletURL, "/wsdl/BindingOperationInput", "Binding Operation Inputs", null, "Binding Operation Input", "BindingOperationInput"), this.buildChildCollection(factory, servletURL, "/wsdl/BindingOperationFault", "Binding Operation Faults", null, "Binding Operation Fault", "BindingOperationFault"), this.buildChildCollection(factory, servletURL, "/wsdl/BindingOperation", "Binding Operations", null, "Binding Operation", "BindingOperation"), this.buildChildCollection(factory, servletURL, "/wsdl/Binding", "Bindings", null, "Binding", "Binding"), this.buildChildCollection(factory, servletURL, "/wsdl/Operation", "Operations", null, "Operation", "Operation"), this.buildChildCollection(factory, servletURL, "/wsdl/OperationOutput", "Operation Outputs", null, "Operation Output", "OperationOutput"), this.buildChildCollection(factory, servletURL, "/wsdl/OperationInput", "Operation Inputs", null, "Operation Input", "OperationInput"), this.buildChildCollection(factory, servletURL, "/wsdl/Part", "Parts", null, "Part", "Part"), this.buildChildCollection(factory, servletURL, "/wsdl/Message", "Messages", null, "Message", "Message"), this.buildChildCollection(factory, servletURL, "/wsdl/Port", "Ports", null, "Port", "Port"), this.buildChildCollection(factory, servletURL, "/wsdl/Fault", "Faults", null, "Fault", "Fault"), this.buildChildCollection(factory, servletURL, "/wsdl/PortType", "Port Types", null, "Port Type", "PortType"), this.buildChildCollection(factory, servletURL, "/wsdl/WsdlService", "WSDL Services", ATOM_ENTRY_MEDIA_TYPE, "WSDL Service", "WsdlService"), this.buildChildCollection(factory, servletURL, "/wsdl/WsdlExtension", "WSDL Extensions", null, "WSDL Extension", "WsdlExtension"), this.buildChildCollection(factory, servletURL, "/wsdl/WsdlDocument", "WSDL Documents", "application/xml", "WSDL Document", "WsdlDocument")}) {
            wsdlModel.addCollection(child);
        }
        wsdlModel.addCollection(this.buildParentCollection(factory, servletURL, children, "/wsdl", "WSDL Model Objects"));
        return wsdlModel;
    }

    private Workspace buildPolicyModel(Factory factory, String servletURL) {
        Collection[] children;
        Workspace policyModel = factory.newWorkspace();
        policyModel.setTitle("Policy Model");
        for (Collection child : children = new Collection[]{this.buildChildCollection(factory, servletURL, "/policy/PolicyExpression", "Policy Expressions", null, "Policy Expressions", "PolicyExpression"), this.buildChildCollection(factory, servletURL, "/policy/PolicyAttachment", "Policy Attachments", null, "Policy Attachment", "PolicyAttachment"), this.buildChildCollection(factory, servletURL, "/policy/PolicyDocument", "Policy Documents", "application/xml", "Policy Document", "PolicyDocument")}) {
            policyModel.addCollection(child);
        }
        policyModel.addCollection(this.buildParentCollection(factory, servletURL, children, "/policy", "Policy Model Objects"));
        return policyModel;
    }

    private Workspace buildQueryModel(Factory factory, String servletURL) {
        Workspace queryModel = factory.newWorkspace();
        queryModel.setTitle("Query Model");
        queryModel.addCollection(this.buildChildCollection(factory, servletURL, "/query", "Query Model Objects", ATOM_ENTRY_MEDIA_TYPE, "Query", "query"));
        return queryModel;
    }

    private void fillArtifactEntryContentDetailsFromResource(Element extensionElement, Resource resource) throws ServletException {
        String errorMessage = "Unable to read content of the artifact";
        try {
            byte[] content;
            Object temp = resource.getContent();
            if (temp instanceof String) {
                content = RegistryUtils.encodeString((String)((String)temp));
            } else if (temp instanceof byte[]) {
                content = (byte[])temp;
            } else {
                log.error((Object)errorMessage);
                throw new SRAMPServletException(errorMessage);
            }
            extensionElement.setAttributeValue(CONTENT_SIZE_ATTRIBUTE, Integer.toString(content.length));
        }
        catch (RegistryException e) {
            log.error((Object)errorMessage, (Throwable)e);
            throw new SRAMPServletException(errorMessage, e);
        }
    }

    private void fillArtifactEntryDetailsFromResource(Element extensionElement, Entry entry, Resource resource) {
        Date lastModified = resource.getLastModified();
        entry.setUpdated(lastModified);
        extensionElement.setAttributeValue(CREATED_BY_ATTRIBUTE, resource.getAuthorUserName());
        extensionElement.setAttributeValue(CREATED_TIMESTAMP_ATTRIBUTE, this.formatDate(resource.getCreatedTime()));
        extensionElement.setAttributeValue(LAST_MODIFIED_TIMESTAMP_ATTRIBUTE, this.formatDate(lastModified));
        extensionElement.setAttributeValue(LAST_MODIFIED_BY_ATTRIBUTE, resource.getLastUpdaterUserName());
        entry.addAuthor(resource.getAuthorUserName());
    }

    private void fillArtifactEntryDescriptionFromResource(Element extensionElement, Entry entry, Resource resource) {
        String description = resource.getDescription();
        if (description == null) {
            description = "";
        }
        entry.setSummary(description);
        extensionElement.setAttributeValue(DESCRIPTION_ATTRIBUTE, description);
    }

    private void fillPropertiesFromResource(Element artifactElement, Resource resource) {
        Set<Object> keySet;
        Properties properties = resource.getProperties();
        if (properties != null && (keySet = properties.keySet()) != null) {
            for (Object keyObj : keySet) {
                String key = (String)keyObj;
                List values = (List)properties.get(key);
                if (values == null) continue;
                for (Object valueObj : values) {
                    String value = (String)valueObj;
                    Element property = this.newExtensionElement(artifactElement, "property");
                    this.newExtensionElement(property, "propertyName").setText(key);
                    this.newExtensionElement(property, "propertyValue").setText(value);
                }
            }
        }
    }

    private Element newExtensionElement(Element parent, String name) {
        return this.abdera.getFactory().newElement(new QName("http://s-ramp.org/xmlns/2010/s-ramp", name, "s-ramp"), (Base)parent);
    }

    private Element newSRAMPArtifact() {
        return this.newExtensionElement(null, "artifact");
    }

    protected void processQueryRequest(HttpServletRequest req, HttpServletResponse resp, String query) throws ServletException, IOException {
        Feed feed = this.abdera.newFeed();
        this.addFeedDetailsForQuery(feed);
        if (query.indexOf("//Service") >= 0) {
            this.processQueryServiceRequest(req, feed, query);
            resp.setContentType(ATOM_MEDIA_TYPE);
            resp.setStatus(200);
            this.serializeOutput(resp, (OMElement)((FOMFeed)feed));
        }
    }

    private void processQueryServiceRequest(HttpServletRequest req, Feed feed, String query) throws ServletException {
        Service[] services;
        for (Service service : services = this.getServicesListForQuery(query)) {
            Entry entry = feed.addEntry();
            entry.setId(URN_UUID + service.getId());
            entry.setTitle(service.getQName().getLocalPart());
            try {
                Resource resource = this.getResource(service.getPath());
                if (resource != null) {
                    entry.setUpdated(resource.getLastModified());
                    entry.setSummary(resource.getDescription());
                    entry.addAuthor(resource.getAuthorUserName());
                }
            }
            catch (GovernanceException e) {
                log.warn((Object)"An error occurred while processing service details", (Throwable)e);
            }
            entry.setContent("");
            String serviceURL = this.getServletURL(req) + SOA_SERVICE_PATH_COMPONENT + service.getId();
            this.addAtomLinksForGETRequest(entry, serviceURL);
        }
    }

    private Service[] getServicesListForQuery(String query) throws ServletException {
        Service[] services;
        final String name = query.indexOf("@name") > 0 ? query.substring(query.indexOf("'") + 1, query.lastIndexOf("'")) : null;
        ServiceManager manager = new ServiceManager((Registry)this.governanceSystemRegistry);
        try {
            services = name == null ? manager.getAllServices() : manager.findServices(new ServiceFilter(){

                public boolean matches(Service service) throws GovernanceException {
                    return name.equals(service.getQName().getLocalPart());
                }
            });
        }
        catch (GovernanceException e) {
            String message = "Unable to locate services";
            log.warn((Object)message, (Throwable)e);
            return new Service[0];
        }
        return services;
    }

    private String getXPathForQuery(HttpServletRequest req) throws ServletException {
        String query = req.getParameter("query");
        if (query != null) {
            try {
                new AXIOMXPath(query);
            }
            catch (JaxenException e) {
                String message = "Invalid XPath query: " + query;
                log.error((Object)message, (Throwable)e);
                throw new SRAMPServletException(message, e);
            }
        }
        return query;
    }

    private void addFeedDetailsForQuery(Feed feed) {
        String uuid = UUIDGenerator.generateUUID();
        feed.setId(uuid);
        feed.setTitle("Query Response");
        feed.setUpdated(new Date());
        feed.addLink(uuid, "self");
    }

    private void addAtomLinksForGETRequest(Entry entry, String serviceURL) {
        entry.addLink(serviceURL, "self", ATOM_ENTRY_MEDIA_TYPE, null, null, -1L);
        entry.addLink(serviceURL, "edit", ATOM_ENTRY_MEDIA_TYPE, null, null, -1L);
        entry.addLink(serviceURL + "/properties", "urn:x-s-ramp:2010:properties", ATOM_FEED_MEDIA_TYPE, null, null, -1L);
        entry.addLink(serviceURL + "/relationships", "urn:x-s-ramp:2010:relationships", ATOM_FEED_MEDIA_TYPE, null, null, -1L);
        entry.addLink(serviceURL + "/relationshipTypes", "urn:x-s-ramp:2010:relationshipTypes", ATOM_FEED_MEDIA_TYPE, null, null, -1L);
        entry.addLink(serviceURL + "/classifications", "urn:x-s-ramp:2010:classifications", ATOM_FEED_MEDIA_TYPE, null, null, -1L);
    }

    private Service[] findServiceForInterfaceId(final String uuid, ServiceManager manager) throws GovernanceException {
        return manager.findServices(new ServiceFilter(){

            public boolean matches(Service service) throws GovernanceException {
                Wsdl[] attachedWsdls = service.getAttachedWsdls();
                if (attachedWsdls.length > 0) {
                    StringBuffer buffer = new StringBuffer(service.getId());
                    for (Wsdl wsdl : attachedWsdls) {
                        buffer.append(wsdl.getId());
                    }
                    return uuid.equals(SRAMPServlet.this.uuidForString(buffer.toString()));
                }
                return false;
            }
        });
    }

    private String uuidForString(String string) {
        String md5 = DigestUtils.md5Hex((String)string);
        return md5.substring(0, 8) + "-" + md5.substring(8, 12) + "-" + md5.substring(12, 16) + "-" + md5.substring(16, 20) + "-" + md5.substring(20, 32);
    }

    private Resource getResource(String path) {
        Resource resource;
        try {
            resource = this.governanceSystemRegistry.get(path);
        }
        catch (Exception e) {
            resource = null;
        }
        return resource;
    }

    private String getServletURL(HttpServletRequest req) {
        try {
            StringBuffer requestURL = req.getRequestURL();
            return requestURL.substring(0, requestURL.indexOf(S_RAMP_SERVLET_CONTEXT) + S_RAMP_SERVLET_CONTEXT.length());
        }
        catch (Exception ignore) {
            return this.servletURL;
        }
    }

    private String formatDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        return formatter.format(date);
    }

    private void serializeOutput(HttpServletResponse resp, OMElement element) throws IOException, ServletException {
        OMDocument document = element.getOMFactory().createOMDocument();
        document.addChild((OMNode)element);
        document.build();
        try {
            document.serialize((OutputStream)resp.getOutputStream());
        }
        catch (XMLStreamException e) {
            String message = "Unable to serialize Atom Feed";
            log.error((Object)message, (Throwable)e);
            throw new SRAMPServletException(message, e);
        }
    }
}

