/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.services.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.utils.CarbonUtils;
import org.xml.sax.SAXException;

public class Util {
    private static final Log log = LogFactory.getLog(Util.class);
    private static RegistryService registryService;
    private static Validator serviceSchemaValidator;

    public static synchronized void setRegistryService(RegistryService service) {
        if (registryService == null) {
            registryService = service;
        }
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static String getServiceConfig(Registry registry) throws Exception {
        return RegistryUtils.decodeBytes((byte[])((byte[])registry.get("/repository/components/org.wso2.carbon.governance/configuration/services/service").getContent()));
    }

    public static boolean validateOMContent(OMElement omContent, Validator validator) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(omContent.toString().getBytes("utf-8"));
            StreamSource xmlFile = new StreamSource(is);
            if (validator != null) {
                validator.validate(xmlFile);
            }
        }
        catch (SAXException e) {
            log.error((Object)"Unable to validate the given xml configuration ", (Throwable)e);
            return false;
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Unsupported content");
            return false;
        }
        catch (IOException e) {
            log.error((Object)"Unable to validate the given file");
            return false;
        }
        return true;
    }

    public static Validator getSchemaValidator(String schemaPath) {
        if (serviceSchemaValidator == null) {
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(new File(schemaPath));
                serviceSchemaValidator = schema.newValidator();
            }
            catch (SAXException e) {
                log.error((Object)("Unable to get a schema validator from the given file path : " + schemaPath));
            }
        }
        return serviceSchemaValidator;
    }

    public static String getServicesSchemaLocation() {
        return CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "conf" + File.separator + "service-ui-config.xsd";
    }

    public static void validateOMContent(OMElement element) throws RegistryException {
        if (!Util.validateOMContent(element, Util.getSchemaValidator(Util.getServicesSchemaLocation()))) {
            String message = "Unable to validate the xml configuration";
            log.error((Object)message);
            throw new RegistryException(message);
        }
    }

    public static OMElement buildOMElement(String payload) throws RegistryException {
        OMElement element;
        try {
            element = AXIOMUtil.stringToOM((String)payload);
            element.build();
        }
        catch (Exception e) {
            String message = "Unable to parse the XML configuration. Please validate the XML configuration";
            log.error((Object)message, (Throwable)e);
            throw new RegistryException(message, (Throwable)e);
        }
        return element;
    }

    static {
        serviceSchemaValidator = null;
    }
}

