/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.validators;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.registry.extensions.interfaces.CustomValidations;
import org.wso2.carbon.governance.registry.extensions.validators.PropertyValueValidator;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;

public class TypedAssociationValidator
extends PropertyValueValidator
implements CustomValidations {
    private static final Log log = LogFactory.getLog(TypedAssociationValidator.class);
    private String associationType = null;
    private String associationDirection = null;
    private String associatedMediaType = null;

    @Override
    public void init(Map parameterMap) {
        if (parameterMap != null) {
            this.associationType = (String)parameterMap.get("associationType");
            this.associationDirection = (String)parameterMap.get("associationDirection");
            this.associatedMediaType = (String)parameterMap.get("associatedMediaType");
            super.init(parameterMap);
        }
    }

    @Override
    public boolean validate(RequestContext context) {
        try {
            String path = context.getResourcePath().getPath();
            Registry systemRegistry = context.getSystemRegistry();
            Association[] associations = systemRegistry.getAssociations(path, this.associationType);
            if (associations == null || associations.length == 0) {
                return false;
            }
            for (Association association : associations) {
                Resource resource;
                if ("url".equals(this.associatedMediaType)) {
                    try {
                        new URL(association.getDestinationPath());
                        return true;
                    }
                    catch (MalformedURLException ignore) {
                        continue;
                    }
                }
                if ("outward".equals(this.associationDirection) && association.getSourcePath().equals(path)) {
                    String destinationPath = association.getDestinationPath();
                    if (!systemRegistry.resourceExists(destinationPath)) continue;
                    Resource resource2 = systemRegistry.get(destinationPath);
                    if (this.associatedMediaType != null && !this.associatedMediaType.equals(resource2.getMediaType()) || !this.validatePropertyOfResource(resource2)) continue;
                    return true;
                }
                if ("inward".equals(this.associationDirection) && association.getDestinationPath().equals(path)) {
                    resource = systemRegistry.get(association.getSourcePath());
                    if (this.associatedMediaType != null && !this.associatedMediaType.equals(resource.getMediaType()) || !this.validatePropertyOfResource(resource)) continue;
                    return true;
                }
                if (association.getSourcePath().equals(path)) {
                    resource = systemRegistry.get(association.getDestinationPath());
                    if (this.associatedMediaType != null && !this.associatedMediaType.equals(resource.getMediaType()) || !this.validatePropertyOfResource(resource)) continue;
                    return true;
                }
                resource = systemRegistry.get(association.getSourcePath());
                if (this.associatedMediaType != null && !this.associatedMediaType.equals(resource.getMediaType()) || !this.validatePropertyOfResource(resource)) continue;
                return true;
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to obtain registry instance", (Throwable)e);
        }
        return false;
    }
}

