/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.FileUtil;

public class GovernanceRegistryExtensionsComponent {
    private static final Log log = LogFactory.getLog(GovernanceRegistryExtensionsComponent.class);
    RegistryService registryService = null;
    private static final String RXT_PATH = "/_system/governance/repository/components/org.wso2.carbon.governance/types";
    private static final String RXT_MEDIA_TYPE = "application/vnd.wso2.registry-ext-type+xml";

    protected void activate(ComponentContext componentContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"GovernanceRegistryExtensionsComponent activated");
        }
        try {
            this.addRxtConfigs();
        }
        catch (RegistryException e) {
            log.error((Object)"Failed to add rxt files to registry", (Throwable)e);
        }
    }

    protected void setRegistryService(RegistryService registryService) {
        if (registryService != null && log.isDebugEnabled()) {
            log.debug((Object)"Registry service initialized");
        }
        this.registryService = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.registryService = null;
    }

    public RegistryService getRegistryService() throws RegistryException {
        return this.registryService;
    }

    private void addRxtConfigs() throws RegistryException {
        UserRegistry systemRegistry;
        String rxtDir = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "resources" + File.separator + "rxts";
        File file = new File(rxtDir);
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".rxt");
            }
        };
        String[] rxtFilePaths = file.list(filenameFilter);
        try {
            systemRegistry = this.registryService.getRegistry("wso2.system.user");
        }
        catch (RegistryException e) {
            throw new RegistryException("Failed to get registry", (Throwable)e);
        }
        for (String rxtPath : rxtFilePaths) {
            String msg;
            String resourcePath = "/_system/governance/repository/components/org.wso2.carbon.governance/types/" + rxtPath;
            try {
                if (systemRegistry.resourceExists(resourcePath)) continue;
                String rxt = FileUtil.readFileToString((String)(rxtDir + File.separator + rxtPath));
                Resource resource = systemRegistry.newResource();
                resource.setContent((Object)rxt.getBytes());
                resource.setMediaType(RXT_MEDIA_TYPE);
                systemRegistry.put(resourcePath, resource);
            }
            catch (IOException e) {
                msg = "Failed to read rxt files";
                throw new RegistryException(msg, (Throwable)e);
            }
            catch (RegistryException e) {
                msg = "Failed to add rxt to registry ";
                throw new RegistryException(msg, (Throwable)e);
            }
        }
    }
}

